/**ABDB**/CREATE TABLE `#__workflows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `extension` varchar(50) NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflows`  VALUES 
('1', '56', '1', 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', '1', '1', '2024-08-15 00:00:51', '19', '2024-08-15 00:00:51', '19', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '58', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '59', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '60', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '61', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '62', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '63', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '64', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '57', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__workflow_associations` (
  `item_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Extension table id value',
  `stage_id` int(11) NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_associations`  VALUES 
('1', '1', 'com_content.article'),
('2', '1', 'com_content.article'),
('3', '1', 'com_content.article'),
('4', '1', 'com_content.article'),
('5', '1', 'com_content.article'),
('6', '1', 'com_content.article'),
('7', '1', 'com_content.article'),
('8', '1', 'com_content.article'),
('9', '1', 'com_content.article'),
('10', '1', 'com_content.article'),
('11', '1', 'com_content.article'),
('12', '1', 'com_content.article'),
('13', '1', 'com_content.article'),
('14', '1', 'com_content.article'),
('15', '1', 'com_content.article'),
('16', '1', 'com_content.article'),
('17', '1', 'com_content.article'),
('18', '1', 'com_content.article');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) NOT NULL COMMENT 'User handle',
  `label` varchar(190) NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `lastResetTime` datetime DEFAULT NULL COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Backup Codes',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) NOT NULL DEFAULT '' COMMENT 'Name of used authentication plugin',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('19', 'Windstripe', 'admin', 'windstripethemes@gmail.com', '$2y$10$TybSE8gyiZorNYVvIR69Ze1osXAe80U3PkfPyoE/195GbLh1JXp4C', '0', '1', '2024-08-15 00:01:01', '2024-08-28 22:24:18', '0', '{\"admin_style\":\"\",\"colorScheme\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', '');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`) 
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('19', '8');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) NOT NULL,
  `profile_value` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/INSERT INTO `#__user_profiles`  VALUES 
('19', 'joomlatoken.enabled', '1', '2'),
('19', 'joomlatoken.token', 'LQV6mKgV7rRT6t9cSwRfI+Q4mMacS5OJcEbhXozvtxc=', '1'),
('19', 'profile.aboutme', '\"Nullam varius luctus pharetra ultrices volpat facilisis donec tortor, nibhkisys habitant curabitur at nunc nisl magna ac rhoncus vehicula sociis tortor nist hendrerit molestie integer. \"', '10'),
('19', 'profile.address1', '\"\"', '1'),
('19', 'profile.address2', '\"\"', '2'),
('19', 'profile.city', '\"\"', '3'),
('19', 'profile.country', '\"\"', '5'),
('19', 'profile.dob', '\"\"', '11'),
('19', 'profile.favoritebook', '\"\"', '9'),
('19', 'profile.phone', '\"\"', '7'),
('19', 'profile.postal_code', '\"\"', '6'),
('19', 'profile.region', '\"\"', '4'),
('19', 'profile.website', '\"https:\\/\\/windstripethemes.com\"', '8');
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_mfa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `method` varchar(100) NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `options` mediumtext NOT NULL,
  `created_on` datetime NOT NULL,
  `last_used` datetime DEFAULT NULL,
  `tries` int(11) NOT NULL DEFAULT 0,
  `last_try` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Multi-factor Authentication settings';
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) NOT NULL,
  `token` varchar(255) NOT NULL,
  `series` varchar(191) NOT NULL,
  `time` varchar(200) NOT NULL,
  `uastring` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) DEFAULT '',
  `description` text NOT NULL,
  `element` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `folder` varchar(20) DEFAULT '',
  `client_id` tinyint(4) DEFAULT 0,
  `version` varchar(32) DEFAULT '',
  `data` text NOT NULL,
  `detailsurl` text NOT NULL,
  `infourl` text NOT NULL,
  `changelogurl` text DEFAULT NULL,
  `extra_query` varchar(1000) DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=346 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('297', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '5.0.2.1', '', 'https://update.joomla.org/language/details5/af-ZA_details.xml', '', '', ''),
('298', '2', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '5.1.1.1', '', 'https://update.joomla.org/language/details5/be-BY_details.xml', '', '', ''),
('299', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/ca-ES_details.xml', '', '', ''),
('300', '2', '0', 'Chinese, Simplified', '', 'pkg_zh-CN', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/zh-CN_details.xml', '', '', ''),
('301', '2', '0', 'Chinese, Traditional', '', 'pkg_zh-TW', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/zh-TW_details.xml', '', '', ''),
('302', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/cs-CZ_details.xml', '', '', ''),
('303', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/da-DK_details.xml', '', '', ''),
('304', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/nl-NL_details.xml', '', '', ''),
('305', '2', '0', 'English, Australia', '', 'pkg_en-AU', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/en-AU_details.xml', '', '', ''),
('306', '2', '0', 'English, Canada', '', 'pkg_en-CA', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/en-CA_details.xml', '', '', ''),
('307', '2', '0', 'English, New Zealand', '', 'pkg_en-NZ', 'package', '', '0', '5.0.3.2', '', 'https://update.joomla.org/language/details5/en-NZ_details.xml', '', '', ''),
('308', '2', '0', 'English, USA', '', 'pkg_en-US', 'package', '', '0', '5.0.3.1', '', 'https://update.joomla.org/language/details5/en-US_details.xml', '', '', ''),
('309', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/et-EE_details.xml', '', '', ''),
('310', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/fi-FI_details.xml', '', '', ''),
('311', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/nl-BE_details.xml', '', '', ''),
('312', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/fr-FR_details.xml', '', '', ''),
('313', '2', '0', 'French, Canada', '', 'pkg_fr-CA', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/fr-CA_details.xml', '', '', ''),
('314', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/ka-GE_details.xml', '', '', ''),
('315', '2', '0', 'German', '', 'pkg_de-DE', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/de-DE_details.xml', '', '', ''),
('316', '2', '0', 'German, Austria', '', 'pkg_de-AT', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/de-AT_details.xml', '', '', ''),
('317', '2', '0', 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/de-LI_details.xml', '', '', ''),
('318', '2', '0', 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/de-LU_details.xml', '', '', ''),
('319', '2', '0', 'German, Switzerland', '', 'pkg_de-CH', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/de-CH_details.xml', '', '', ''),
('320', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '5.1.3.1', '', 'https://update.joomla.org/language/details5/el-GR_details.xml', '', '', ''),
('321', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/hu-HU_details.xml', '', '', ''),
('322', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/it-IT_details.xml', '', '', ''),
('323', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/ja-JP_details.xml', '', '', ''),
('324', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '5.0.0.4', '', 'https://update.joomla.org/language/details5/kk-KZ_details.xml', '', '', ''),
('325', '2', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '5.0.2.1', '', 'https://update.joomla.org/language/details5/ko-KR_details.xml', '', '', ''),
('326', '2', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/lv-LV_details.xml', '', '', ''),
('327', '2', '0', 'Pashto Afghanistan', '', 'pkg_ps-AF', 'package', '', '0', '5.0.1.1', '', 'https://update.joomla.org/language/details5/ps-AF_details.xml', '', '', ''),
('328', '2', '0', 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', '0', '5.1.3.1', '', 'https://update.joomla.org/language/details5/fa-IR_details.xml', '', '', ''),
('329', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/pl-PL_details.xml', '', '', ''),
('330', '2', '0', 'Portuguese, Brazil', '', 'pkg_pt-BR', 'package', '', '0', '5.1.2.3', '', 'https://update.joomla.org/language/details5/pt-BR_details.xml', '', '', ''),
('331', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '5.1.1.1', '', 'https://update.joomla.org/language/details5/ro-RO_details.xml', '', '', ''),
('332', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '5.1.1.1', '', 'https://update.joomla.org/language/details5/ru-RU_details.xml', '', '', ''),
('333', '2', '0', 'Serbian, Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/sr-RS_details.xml', '', '', ''),
('334', '2', '0', 'Serbian, Latin', '', 'pkg_sr-YU', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/sr-YU_details.xml', '', '', ''),
('335', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '5.1.3.1', '', 'https://update.joomla.org/language/details5/sk-SK_details.xml', '', '', ''),
('336', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/sl-SI_details.xml', '', '', ''),
('337', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '5.1.0.1', '', 'https://update.joomla.org/language/details5/es-ES_details.xml', '', '', ''),
('338', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/sv-SE_details.xml', '', '', ''),
('339', '2', '0', 'Tamil, India', '', 'pkg_ta-IN', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/ta-IN_details.xml', '', '', ''),
('340', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/th-TH_details.xml', '', '', ''),
('341', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '5.1.3.1', '', 'https://update.joomla.org/language/details5/tr-TR_details.xml', '', '', ''),
('342', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '5.1.3.1', '', 'https://update.joomla.org/language/details5/uk-UA_details.xml', '', '', ''),
('343', '2', '0', 'Urdu, Pakistan', '', 'pkg_ur-PK', 'package', '', '0', '5.1.2.1', '', 'https://update.joomla.org/language/details5/ur-PK_details.xml', '', '', ''),
('344', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '5.1.4.1', '', 'https://update.joomla.org/language/details5/cy-GB_details.xml', '', '', ''),
('345', '15', '0', 'shaper_helixultimate', 'Helix Ultimate', 'shaper_helixultimate', 'template', '', '0', '2.1.1', '', 'https://www.joomshaper.com/updates/shaper-helixultimate.xml', '', NULL, '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '239'),
('2', '240'),
('3', '24'),
('14', '253'),
('15', '254'),
('16', '258'),
('17', '244'),
('18', '257');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` text NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'tuf', 'https://update.joomla.org/cms/', '1', '1724884267', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_5.xml', '1', '1724883863', '', NULL, NULL),
('3', 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1724883864', '', NULL, NULL),
('14', 'System - Helix Ultimate Framework', 'extension', 'http://www.joomshaper.com/updates/plg-system-helixultimate.xml', '1', '1724883864', '', NULL, NULL),
('15', 'shaper_helixultimate', 'extension', 'https://www.joomshaper.com/updates/shaper-helixultimate.xml', '1', '1724883865', '', NULL, NULL),
('16', '', 'collection', 'http://www.hikashop.com/component/updateme/updatexml/component-hikashop/level-Starter/file-extension.xml', '1', '1724883865', '', NULL, NULL),
('17', 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro-next.xml', '1', '1724883866', '', NULL, NULL),
('18', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1724883866', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext DEFAULT NULL,
  `core_state` tinyint(4) NOT NULL DEFAULT 0,
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` text DEFAULT NULL,
  `core_featured` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text DEFAULT NULL,
  `core_urls` text DEFAULT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text DEFAULT NULL,
  `core_metadesc` text DEFAULT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/INSERT INTO `#__ucm_content`  VALUES 
('1', 'com_content.article', 'Solar will give you peace mind knowing that if something', 'solar-will-give-you-peace-mind-knowing-that-if-something', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-19 16:14:17', '*', '2024-08-17 00:35:39', NULL, '1', '114', '{\"image_intro\":\"images\\/blog\\/01.jpg#joomlaImage:\\/\\/local-images\\/blog\\/01.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '38', '5', '0', '', '', '8', '1'),
('2', 'com_content.article', 'This will give you peace mind knowing that if Many', 'this-will-give-you-peace-mind-knowing-that-if-many', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:33:48', '*', '2024-08-17 00:35:39', NULL, '2', '115', '{\"image_intro\":\"images\\/blog\\/02.jpg#joomlaImage:\\/\\/local-images\\/blog\\/02.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '10', '0', '', '', '8', '1'),
('3', 'com_content.article', 'Energytic give you peace mind knowing that if something', 'energytic-give-you-peace-mind-knowing-that-if-something', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:34:13', '*', '2024-08-17 00:35:39', NULL, '3', '116', '{\"image_intro\":\"images\\/blog\\/03.jpg#joomlaImage:\\/\\/local-images\\/blog\\/03.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '8', '1'),
('4', 'com_content.article', 'IT will give you peace mind knowing that if Happen', 'it-will-give-you-peace-mind-knowing-that-if-happen', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:34:38', '*', '2024-08-17 00:35:39', NULL, '4', '117', '{\"image_intro\":\"images\\/blog\\/04.jpg#joomlaImage:\\/\\/local-images\\/blog\\/04.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '8', '1'),
('5', 'com_content.article', 'Knowledge will give you peace mind knowing that if Protocol', 'knowledge-will-give-you-peace-mind-knowing-that-if-protocol', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:35:37', '*', '2024-08-17 00:35:39', NULL, '5', '118', '{\"image_intro\":\"images\\/blog\\/05.jpg#joomlaImage:\\/\\/local-images\\/blog\\/05.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '8', '1'),
('6', 'com_content.article', 'This will give you peace mind knowing that if something', 'this-will-give-you-peace-mind-knowing-that-if-something', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:36:01', '*', '2024-08-17 00:35:39', NULL, '6', '119', '{\"image_intro\":\"images\\/blog\\/06.jpg#joomlaImage:\\/\\/local-images\\/blog\\/06.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '8', '1'),
('7', 'com_content.article', 'Given will give you peace mind knowing that if May', 'given-will-give-you-peace-mind-knowing-that-if-may', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:36:25', '*', '2024-08-17 00:35:39', NULL, '7', '120', '{\"image_intro\":\"images\\/blog\\/07.jpg#joomlaImage:\\/\\/local-images\\/blog\\/07.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '8', '1'),
('8', 'com_content.article', 'Totally will give you peace mind knowing that if something', 'totally-will-give-you-peace-mind-knowing-that-if-something', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:36:52', '*', '2024-08-17 00:35:39', NULL, '8', '121', '{\"image_intro\":\"images\\/blog\\/08.jpg#joomlaImage:\\/\\/local-images\\/blog\\/08.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '8', '1'),
('9', 'com_content.article', 'Happen will give you peace mind knowing that if Kids', 'happen-will-give-you-peace-mind-knowing-that-if-kids', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:37:15', '*', '2024-08-17 00:35:39', NULL, '9', '122', '{\"image_intro\":\"images\\/blog\\/09.jpg#joomlaImage:\\/\\/local-images\\/blog\\/09.jpg?width=424&height=280\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '8', '1'),
('10', 'com_content.article', 'We would love to share a similar experience', 'we-would-love-to-share-a-similar-experience', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:37:39', '*', '2024-08-17 00:35:39', NULL, '10', '127', '{\"image_intro\":\"images\\/blog\\/19.jpg#joomlaImage:\\/\\/local-images\\/blog\\/19.jpg?width=85&height=85\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '6', '0', '', '', '9', '1'),
('11', 'com_content.article', 'We would love to share a similar experience', 'this-will-give-you-peace-mind-knowing-that-if-many', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:38:00', '*', '2024-08-17 00:35:39', NULL, '11', '128', '{\"image_intro\":\"images\\/blog\\/20.jpg#joomlaImage:\\/\\/local-images\\/blog\\/20.jpg?width=85&height=85\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '7', '0', '', '', '9', '1'),
('12', 'com_content.article', 'We would love to share a similar experience', 'solar-will-give-you-peace-mind-knowing-that-if-something', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:38:24', '*', '2024-08-17 00:35:39', NULL, '12', '129', '{\"image_intro\":\"images\\/blog\\/21.jpg#joomlaImage:\\/\\/local-images\\/blog\\/21.jpg?width=85&height=85\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '5', '0', '', '', '9', '1'),
('13', 'com_content.article', 'Solar Training Program Series: Why is Remote Energy Focused on Training Solar Educators?', 'solar-training-program-series-why-is-remote-energy-focused-on-training-solar-educators', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:38:48', '*', '2024-08-17 00:35:39', NULL, '13', '133', '{\"image_intro\":\"images\\/blog\\/25.jpg#joomlaImage:\\/\\/local-images\\/blog\\/25.jpg?width=608&height=282\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '8', '0', '', '', '10', '1'),
('14', 'com_content.article', '2019 Gattermann Award wind honors Brad Burkhart Meyer', '2019-gattermann-award-wind-honors-brad-burkhart-meyer', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:39:12', '*', '2024-08-17 00:35:39', NULL, '14', '134', '{\"image_intro\":\"images\\/blog\\/26.jpg#joomlaImage:\\/\\/local-images\\/blog\\/26.jpg?width=232&height=232\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '11', '0', '', '', '11', '1'),
('15', 'com_content.article', '2021 Batterman Award honors Brad Burkhart Meyer Green', '2021-batterman-award-honors-brad-burkhart-meyer-green', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:39:35', '*', '2024-08-17 00:35:39', NULL, '15', '135', '{\"image_intro\":\"images\\/blog\\/27.jpg#joomlaImage:\\/\\/local-images\\/blog\\/27.jpg?width=232&height=232\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '8', '0', '', '', '11', '1'),
('16', 'com_content.article', 'Solar Training Program Series on Training Solar Educators?', 'solar-training-program-series-on-training-solar-educators', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:40:00', '*', '2024-08-17 00:35:39', NULL, '16', '147', '{\"image_intro\":\"images\\/blog\\/30.jpg#joomlaImage:\\/\\/local-images\\/blog\\/30.jpg?width=424&height=380\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '6', '0', '', '', '12', '1'),
('17', 'com_content.article', 'Explain how hydropower clean electricity without burning.', 'explain-how-hydropower-clean-electricity-without-burning', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:40:24', '*', '2024-08-17 00:35:39', NULL, '17', '148', '{\"image_intro\":\"images\\/blog\\/31.jpg#joomlaImage:\\/\\/local-images\\/blog\\/31.jpg?width=424&height=380\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '11', '0', '', '', '12', '1'),
('18', 'com_content.article', 'Facing economic advantages of hydropower, including job', 'facing-economic-advantages-of-hydropower-including-job', '<p>Collaboratively pontificate bleeding edge resources with inexpensive methodologies globally initiate multidisciplinary compatible architectures pidiously repurpose leading edge growth strategies with just in time web readiness communicate timely meta services </p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '19', '', '2024-08-17 00:35:39', '19', '2024-08-28 00:40:48', '*', '2024-08-17 00:35:39', NULL, '18', '149', '{\"image_intro\":\"images\\/blog\\/32.jpg#joomlaImage:\\/\\/local-images\\/blog\\/32.jpg?width=424&height=380\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/blog\\/10.jpg#joomlaImage:\\/\\/local-images\\/blog\\/10.jpg?width=872&height=500\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '9', '0', '', '', '12', '1'),
('19', 'com_hikashop.product', 'Solar Power Boards', 'goalkeeper-gloves', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '1', '0', '{}', '{}', '49', '1', '0', '', '', '1', '10000'),
('20', 'com_hikashop.product', 'Solar power board', 'men-football-jersey', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '13', '0', '{}', '{}', '0', '1', '0', '', '', '1', '10000'),
('21', 'com_hikashop.product', 'Enphase Microinverter', 'men-football-tarf-new', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '14', '0', '{}', '{}', '0', '1', '0', '', '', '1', '10000'),
('22', 'com_hikashop.product', 'Blavor Solar Charger', 'new-world-cup-football', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '15', '0', '{}', '{}', '0', '1', '0', '', '', '1', '10000'),
('23', 'com_hikashop.product', 'Solar power house', 'sports-shoes', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '16', '0', '{}', '{}', '0', '1', '0', '', '', '1', '10000'),
('24', 'com_hikashop.product', 'Blueplanet Inverter', 'stylish-cap', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '17', '0', '{}', '{}', '0', '1', '0', '', '', '1', '10000'),
('25', 'com_hikashop.product', 'Solar Light Boards', 'club-t-shirt', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '18', '0', '{}', '{}', '0', '1', '0', '', '', '1', '10000'),
('26', 'com_hikashop.product', 'Eco Portable Power', 'club-jersey-new', '<div class=\"short-description\">Progressively incentivize B2C content vis-a-vis reliable experiences. Phosfluorescently benchmark unique e-services whereas transparent collaboration and idea-sharing. Enthusiastically communicate maintainable networks via global metrics. Credibly negotiate progressive bandwidth for go forward e-commerce. Rapidiously evolve magnetic initiatives through client-based portals.</div>\r\n<div class=\"long-description\">\r\n<p class=\"mb-3\">Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users. Synergistically scale B2C e-business rather than quality products. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Synergistically incubate extensible outsourcing via magnetic sources. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models.</p>\r\n<p>Interactively revolutionize intuitive collaboration and idea-sharing through high-quality models. Credibly e-enable e-business materials with competitive products. Enthusiastically extend unique leadership before timely users.</p>\r\n</div>', '1', NULL, NULL, '0', NULL, '0', '', '19', '', '0000-00-00 00:00:00', '19', '0000-00-00 00:00:00', '', NULL, NULL, '19', '0', '{}', '{}', '0', '1', '0', '', '', '1', '10000');
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(11) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ucm_base`  VALUES 
('1', '1', '1', '0'),
('2', '2', '1', '0'),
('3', '3', '1', '0'),
('4', '4', '1', '0'),
('5', '5', '1', '0'),
('6', '6', '1', '0'),
('7', '7', '1', '0'),
('8', '8', '1', '0'),
('9', '9', '1', '0'),
('10', '10', '1', '0'),
('11', '11', '1', '0'),
('12', '12', '1', '0'),
('13', '13', '1', '0'),
('14', '14', '1', '0'),
('15', '15', '1', '0'),
('16', '16', '1', '0'),
('17', '17', '1', '0'),
('18', '18', '1', '0'),
('19', '1', '10000', '0'),
('20', '13', '10000', '0'),
('21', '14', '10000', '0'),
('22', '15', '10000', '0'),
('23', '16', '10000', '0'),
('24', '17', '10000', '0'),
('25', '18', '10000', '0'),
('26', '19', '10000', '0');
/**ABDB**/CREATE TABLE `#__tuf_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `root` text DEFAULT NULL,
  `targets` text DEFAULT NULL,
  `snapshot` text DEFAULT NULL,
  `timestamp` text DEFAULT NULL,
  `mirrors` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Secure TUF Updates';
/**ABDB**/INSERT INTO `#__tuf_metadata`  VALUES 
('1', '1', '{\"signed\":{\"_type\":\"root\",\"spec_version\":\"1.0\",\"version\":4,\"expires\":\"2025-03-02T16:38:55Z\",\"keys\":{\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"9b2af2d9b9727227735253d795bd27ea8f0e294a5f3603e822dc5052b44802b9\"}},\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"a18e5ebabc19d5d5984b601a292ece61ba3662ab2d071dc520da5bd4f8948799\"}},\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"cb0a7a131961a20edea051d6dc2b091fb650bd399bd8514adb67b3c60db9f8f9\"}},\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"589d029a68b470deff1ca16dbf3eea6b5b3fcba0ae7bb52c468abc7fb058b2a2\"}},\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"6043c8bacc76ac5c9750f45454dd865c6ca1fc57d69e14cc192cfd420f6a66a9\"}},\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"ad1950e117b29ebe7a38635a2e574123e07571e4f9a011783e053b5f15d2562a\"}},\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"5d451915bc2b93a0e4e4745bc6a8b292d58996d50e0fb66c78c7827152a65879\"}}},\"roles\":{\"root\":{\"keyids\":[\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\"],\"threshold\":1},\"snapshot\":{\"keyids\":[\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\"],\"threshold\":1},\"targets\":{\"keyids\":[\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\"],\"threshold\":1},\"timestamp\":{\"keyids\":[\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\"],\"threshold\":1}},\"consistent_snapshot\":true},\"signatures\":[{\"keyid\":\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"sig\":\"1c8060aab4c5290dc398199d8f124701bd3f7d3fb47d688e3e61d20eeb90d6e387556ce680ba8db9b99f15332df64da349a03344f50ab4f1fe491efdf88f170c\"}]}', '{\"signed\":{\"_type\":\"targets\",\"spec_version\":\"1.0\",\"version\":22,\"expires\":\"2024-11-27T08:15:55Z\",\"targets\":{\"Joomla_5.1.2-Stable-Upgrade_Package.zip\":{\"length\":28134889,\"hashes\":{\"sha512\":\"d6b46cdedb9b31d01a607fe4c2f3a830a3265ed6ae5c0cb7b0f836b1b016ee7c639bd8948df00baf1b61a87f2fc71368a80b39e67ef9ec2b8842ee0ab09a620f\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.1.2 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-1-2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.1.2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.1.2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5909-joomla-5-1-2-and-joomla-4-4-6-security-and-bug-fix-release.html\",\"title\":\"Joomla! 5.1.2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.1.2\",\"php_minimum\":\"8.1.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.1.2\"}},\"Joomla_5.1.3-Stable-Update_Package.zip\":{\"length\":28274400,\"hashes\":{\"sha512\":\"db1a2de75ab75230235a64956ef6f4f26a44eb1784248eeb728cee01c81e1978581e8f8e793c2378412609039d52d5fcc0f2d16d499cb85914d9253413a1a85b\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.1.3 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-1-3/Joomla_5.1.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.1.3/Joomla_5.1.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.1.3/Joomla_5.1.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5910-joomla-5-1-3-and-4-4-7-security-and-bug-fix-release.html\",\"title\":\"Joomla! 5.1.3 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.1.3\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.1.3\"}},\"Joomla_5.1.4-Stable-Update_Package.zip\":{\"length\":28289998,\"hashes\":{\"sha512\":\"97c556bddd77604d89106077e09e43845927e0507179bfca7646aadddaf69246079d71e83ceb33b714f4437d836deac8d3ec12fc103024524e2ae1ae41885104\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.1.4 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-1-4/Joomla_5.1.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.1.4/Joomla_5.1.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.1.4/Joomla_5.1.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5911-joomla-5-1-4-and-joomla-4-4-8-are-here.html\",\"title\":\"Joomla! 5.1.4 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.1.4\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.1.4\"}},\"Joomla_5.2.0-beta1-Beta-Update_Package.zip\":{\"length\":27777050,\"hashes\":{\"sha512\":\"8c72960f3d1586939c02df43619cf76c35eb313b36df7aaca89cefebe4995aa2793ba1da79c3324295a65222ff97fe7d9f41c5af0fbaef187cbbd58dcd65bc96\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.2.0-beta1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.2.0-beta1/Joomla_5.2.0-beta1-Beta-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://developer.joomla.org/news/947-joomla-5-2-0-beta-1.html\",\"title\":\"Joomla! 5.2.0-beta1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.2.0-beta1\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Beta\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.2.0-beta1\"}}}},\"signatures\":[{\"keyid\":\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"sig\":\"3b511116297601a9ab96f263724ed9916b7b3a9f1c8511491e64d33adcf9fbf2d98bbe4dce31a305bc28cb6387058ccff7d9c0c247ff29e01d737458b5d4c506\"},{\"keyid\":\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"sig\":\"7fedc251e94137a404127c4d181067ef27d75caaf5086ec0c97854ecfea8c16ef3b15e45c7ac880492fa7a3e64dd42925e59be74179911e8d387cf3ff0d59e0f\"}]}', '{\"signed\":{\"_type\":\"snapshot\",\"spec_version\":\"1.0\",\"version\":25,\"expires\":\"2025-03-25T16:00:25Z\",\"meta\":{\"targets.json\":{\"length\":5102,\"hashes\":{\"sha512\":\"89f7e65d150eb0f1c0ea491165aa1bc9d5d324dede1c8fa4e61ba329b42c554233f8df814d19c358b5fa2fb30eee5552fb2bf94bc5efcd43a8e48337dc2bd378\"},\"version\":22}}},\"signatures\":[{\"keyid\":\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"sig\":\"8071b4304fbc07bdb1ceabab500ac4bad44f59df2c335ec95f83a042ecb2b1a795a6eadc5d6ede573b779670fbab68d3126b6408549540b1888cedf1b791f604\"}]}', '{\"signed\":{\"_type\":\"timestamp\",\"spec_version\":\"1.0\",\"version\":264,\"expires\":\"2024-08-30T16:04:08Z\",\"meta\":{\"snapshot.json\":{\"length\":531,\"hashes\":{\"sha512\":\"bfd4842c98b2b66f4e084958bae9bbd077037086e7427866f5a9d09ab13374230a7eae94852fad892dda5654d4748f3bb3529a6a5c818610d1c8ba5b7c5b21f8\"},\"version\":25}}},\"signatures\":[{\"keyid\":\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\",\"sig\":\"7766a8ac93a1e52a21a4dc99a9d9c71514656b8c32b1d7877a82725f426cd336c5d85013b896cd12e7604bbfa31e189e9c9c4dae4d39c803ba91e74b2d3a8d0c\"}]}', NULL);
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `inheritable` tinyint(4) NOT NULL DEFAULT 0,
  `parent` varchar(50) DEFAULT '',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('10', 'atum', '1', '1', 'Atum - Default', '1', '', '{\"hue\":\"hsl(214, 63%, 20%)\",\"bg-light\":\"#f0f4fb\",\"text-dark\":\"#495057\",\"text-light\":\"#ffffff\",\"link-color\":\"#2a69b8\",\"special-color\":\"#001b4c\",\"colorScheme\":\"os\",\"monochrome\":\"0\",\"loginLogo\":\"\",\"loginLogoAlt\":\"\",\"logoBrandLarge\":\"\",\"logoBrandLargeAlt\":\"\",\"logoBrandSmall\":\"\",\"logoBrandSmallAlt\":\"\"}'),
('11', 'cassiopeia', '0', '0', 'Cassiopeia - Default', '1', '', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":0,\"backTop\":0}'),
('12', 'solari', '0', '1', 'Solari - Default', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo\\/logo-01.svg\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"30px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/fav.png\",\"header_style\":\"\",\"header_height\":\"80px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"1335\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"\",\"contact_mobile\":\"\",\"contact_email\":\"\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-08-15 00:33:14\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset1\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#4AAB3D\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"top\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"top1\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"grid_size\\\":12}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"2+6+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"header\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":2,\\\"column_type\\\":\\\"0\\\",\\\"name\\\":\\\"logo\\\",\\\"sticky_position\\\":\\\"0\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":null,\\\"xl_col\\\":null,\\\"lg_col\\\":null,\\\"md_col\\\":\\\"4\\\",\\\"sm_col\\\":\\\"9\\\",\\\"xs_col\\\":\\\"9\\\",\\\"hide_on_phone\\\":\\\"0\\\",\\\"hide_on_large_phone\\\":\\\"0\\\",\\\"hide_on_tablet\\\":\\\"0\\\",\\\"hide_on_small_desktop\\\":\\\"0\\\",\\\"hide_on_desktop\\\":\\\"0\\\",\\\"hide_on_ex_large_desktop\\\":\\\"0\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":6,\\\"column_type\\\":\\\"0\\\",\\\"name\\\":\\\"menu\\\",\\\"sticky_position\\\":\\\"0\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":null,\\\"xl_col\\\":null,\\\"lg_col\\\":null,\\\"md_col\\\":\\\"2\\\",\\\"sm_col\\\":\\\"3\\\",\\\"xs_col\\\":\\\"3\\\",\\\"hide_on_phone\\\":\\\"0\\\",\\\"hide_on_large_phone\\\":\\\"0\\\",\\\"hide_on_tablet\\\":\\\"0\\\",\\\"hide_on_small_desktop\\\":\\\"0\\\",\\\"hide_on_desktop\\\":\\\"0\\\",\\\"hide_on_ex_large_desktop\\\":\\\"0\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"column_type\\\":\\\"0\\\",\\\"name\\\":\\\"position1\\\",\\\"sticky_position\\\":\\\"0\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":null,\\\"xl_col\\\":null,\\\"lg_col\\\":null,\\\"md_col\\\":\\\"6\\\",\\\"sm_col\\\":null,\\\"xs_col\\\":null,\\\"hide_on_phone\\\":\\\"1\\\",\\\"hide_on_large_phone\\\":\\\"1\\\",\\\"hide_on_tablet\\\":\\\"0\\\",\\\"hide_on_small_desktop\\\":\\\"0\\\",\\\"hide_on_desktop\\\":\\\"0\\\",\\\"hide_on_ex_large_desktop\\\":\\\"0\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_desktop\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_tablet\\\":0,\\\"hide_large_mobile\\\":1,\\\"hide_mobile\\\":1,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Main Body\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"Footer\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":12,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"200X200\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"show_list_tags\":\"1\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"author_info\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disqus\",\"comment_categories\":[\"2\",\"8\",\"9\",\"10\",\"11\",\"12\"],\"comment_disqus_subdomain\":\"localhost-codgjub77d\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"12\",\"template\":\"solari\",\"client_id\":\"0\",\"home\":\"1\",\"title\":\"Solari - Default\"}'),
('13', 'solari', '0', '0', 'Solari - Home Renewable Energy', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo\\/logo-01.svg\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"30px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/fav.png\",\"header_style\":\"\",\"header_height\":\"80px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"1335\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"\",\"contact_mobile\":\"\",\"contact_email\":\"\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-08-15 00:33:14\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset1\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#4AAB3D\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"2+6+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"header\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":2,\\\"column_type\\\":\\\"0\\\",\\\"name\\\":\\\"logo\\\",\\\"sticky_position\\\":\\\"0\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":null,\\\"xl_col\\\":null,\\\"lg_col\\\":null,\\\"md_col\\\":\\\"6\\\",\\\"sm_col\\\":\\\"6\\\",\\\"xs_col\\\":\\\"6\\\",\\\"hide_on_phone\\\":\\\"0\\\",\\\"hide_on_large_phone\\\":\\\"0\\\",\\\"hide_on_tablet\\\":\\\"0\\\",\\\"hide_on_small_desktop\\\":\\\"0\\\",\\\"hide_on_desktop\\\":\\\"0\\\",\\\"hide_on_ex_large_desktop\\\":\\\"0\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":6,\\\"column_type\\\":\\\"0\\\",\\\"name\\\":\\\"menu\\\",\\\"sticky_position\\\":\\\"0\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":null,\\\"xl_col\\\":null,\\\"lg_col\\\":null,\\\"md_col\\\":\\\"4\\\",\\\"sm_col\\\":\\\"3\\\",\\\"xs_col\\\":\\\"3\\\",\\\"hide_on_phone\\\":\\\"0\\\",\\\"hide_on_large_phone\\\":\\\"0\\\",\\\"hide_on_tablet\\\":\\\"0\\\",\\\"hide_on_small_desktop\\\":\\\"0\\\",\\\"hide_on_desktop\\\":\\\"0\\\",\\\"hide_on_ex_large_desktop\\\":\\\"0\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"column_type\\\":\\\"0\\\",\\\"name\\\":\\\"position2\\\",\\\"sticky_position\\\":\\\"0\\\",\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":null,\\\"xl_col\\\":null,\\\"lg_col\\\":null,\\\"md_col\\\":\\\"2\\\",\\\"sm_col\\\":\\\"3\\\",\\\"xs_col\\\":\\\"3\\\",\\\"hide_on_phone\\\":\\\"0\\\",\\\"hide_on_large_phone\\\":\\\"0\\\",\\\"hide_on_tablet\\\":\\\"0\\\",\\\"hide_on_small_desktop\\\":\\\"0\\\",\\\"hide_on_desktop\\\":\\\"0\\\",\\\"hide_on_ex_large_desktop\\\":\\\"0\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_desktop\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_tablet\\\":0,\\\"hide_large_mobile\\\":1,\\\"hide_mobile\\\":1,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Main Body\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"Footer\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":12,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"200X200\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"show_list_tags\":\"1\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"author_info\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disqus\",\"comment_categories\":[\"2\",\"8\",\"9\",\"10\",\"11\",\"12\"],\"comment_disqus_subdomain\":\"localhost-codgjub77d\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"#sp-header:not(.header-sticky) {\\r\\nposition: absolute;\\r\\npadding: 32px 0px;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .logo {\\r\\n\\tpadding: 0;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .logo img {\\r\\nfilter: invert() brightness(10);\\r\\n}\\r\\n\\r\\n#sp-header .sp-megamenu-parent {\\r\\n\\ttext-align: left;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .sp-megamenu-parent > li > a, #sp-header:not(.header-sticky) .sp-megamenu-parent > li > span, #sp-header:not(.header-sticky) .sp-megamenu-parent > li:last-child > a {\\r\\n\\tcolor: #fff;\\r\\n}\\r\\n\\r\\n#sp-header.header-sticky #sp-position2 .sppb-addon-text-block rect {\\r\\n  fill: var(--maincolor) !important;\\r\\n}\\r\\n\\r\\n#sp-header.header-sticky #sp-position2 .sppb-btn-link {\\r\\ncolor: var(--maincolor);\\r\\n}\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"13\",\"template\":\"solari\",\"client_id\":\"0\",\"home\":\"0\",\"title\":\"Solari - Home Renewable Energy\"}'),
('14', 'solari', '0', '0', 'Solari - Home Hydro Power & Solar Solution', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo\\/logo-01.svg\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"30px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/fav.png\",\"header_style\":\"\",\"header_height\":\"80px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"1335\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"\",\"contact_mobile\":\"\",\"contact_email\":\"\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-08-15 00:33:14\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset1\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#4AAB3D\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+6+3\\\",\\\"settings\\\":{\\\"name\\\":\\\"header\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":6,\\\"sm_col\\\":6,\\\"md_col\\\":6,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"logo\\\",\\\"column_type\\\":0,\\\"grid_size\\\":3,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":3,\\\"sm_col\\\":3,\\\"md_col\\\":4,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"menu\\\",\\\"column_type\\\":0,\\\"grid_size\\\":6,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":3,\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":3,\\\"sm_col\\\":3,\\\"md_col\\\":2,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"position2\\\",\\\"column_type\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_desktop\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_tablet\\\":0,\\\"hide_large_mobile\\\":1,\\\"hide_mobile\\\":1,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Main Body\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"Footer\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":12,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"200X200\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"show_list_tags\":\"1\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"author_info\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disqus\",\"comment_categories\":[\"2\",\"8\",\"9\",\"10\",\"11\",\"12\"],\"comment_disqus_subdomain\":\"localhost-codgjub77d\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"#sp-header {\\r\\nposition: absolute;\\r\\npadding: 32px 0px;\\r\\n}\\r\\n\\r\\n#sp-header.header-sticky {\\r\\n\\tbackground: #1B1B1B;\\r\\npadding: 0px;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .logo {\\r\\n\\tpadding: 0;\\r\\n}\\r\\n\\r\\n#sp-header .logo img {\\r\\nfilter: invert() brightness(10);\\r\\n}\\r\\n\\r\\n#sp-header .sp-megamenu-parent > li > a, #sp-header .sp-megamenu-parent > li > span, #sp-header .sp-megamenu-parent > li:last-child > a {\\r\\n\\tcolor: #fff;\\r\\n}\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"14\",\"template\":\"solari\",\"client_id\":\"0\",\"home\":\"0\",\"title\":\"Solari - Home Hydro Power\"}'),
('15', 'solari', '0', '0', 'Solari - Solar Shop', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo\\/logo-01.svg\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"30px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/fav.png\",\"header_style\":\"\",\"header_height\":\"80px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"1335\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"\",\"contact_mobile\":\"\",\"contact_email\":\"\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-08-15 00:33:14\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset1\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#4AAB3D\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"top\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"top1\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"grid_size\\\":12}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"2+6+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"header\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":2,\\\"column_type\\\":0,\\\"name\\\":\\\"logo\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":4,\\\"sm_col\\\":9,\\\"xs_col\\\":9,\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":6,\\\"column_type\\\":0,\\\"name\\\":\\\"menu\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":2,\\\"sm_col\\\":3,\\\"xs_col\\\":3,\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":1,\\\"hide_on_phone\\\":1,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":6,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"position3\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_desktop\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_tablet\\\":0,\\\"hide_large_mobile\\\":1,\\\"hide_mobile\\\":1,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Main Body\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"left\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":4}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"right\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"grid_size\\\":4,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"name\\\":\\\"Footer\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":12,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"200X200\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"show_list_tags\":\"1\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"author_info\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disqus\",\"comment_categories\":[\"2\",\"8\",\"9\",\"10\",\"11\",\"12\"],\"comment_disqus_subdomain\":\"localhost-codgjub77d\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"body .sppb-btn, body .sppb-sp-slider-button .sp-slider-btn-text, .login .btn, .registration form > div .btn, .hikashop_vote_form .button, .article-list .article .readmore a, .sppb-readmore {\\r\\nborder-radius: 6px;\\r\\n}\\r\\n\\r\\nbody .sppb-btn::before, body .sppb-sp-slider-button .sp-slider-btn-text::before, .login .btn::before, .registration form > div .btn::before, .hikashop_vote_form .button::before, .article-list .article .readmore a::before, .sppb-readmore::before {\\r\\nborder-radius: 6px;\\r\\n}\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"15\",\"template\":\"solari\",\"client_id\":\"0\",\"home\":\"0\",\"title\":\"Solari - Solar Shop\"}'),
('16', 'solari', '0', '0', 'Solari - Default - One Page', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo\\/logo-01.svg\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"30px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/fav.png\",\"header_style\":\"\",\"header_height\":\"80px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"1335\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"\",\"contact_mobile\":\"\",\"contact_email\":\"\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-08-15 00:33:14\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset1\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#4AAB3D\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"name\\\":\\\"top\\\",\\\"fluidrow\\\":1,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":12,\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"top1\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"2+6+4\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"header\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":9,\\\"sm_col\\\":9,\\\"md_col\\\":4,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"logo\\\",\\\"column_type\\\":0,\\\"grid_size\\\":2}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":3,\\\"sm_col\\\":3,\\\"md_col\\\":2,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"menu\\\",\\\"column_type\\\":0,\\\"grid_size\\\":6}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":1,\\\"hide_on_phone\\\":1,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":6,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"position1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":4}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"hide_mobile\\\":1,\\\"hide_large_mobile\\\":1,\\\"hide_tablet\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":12,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"title\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"Main Body\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"left\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"column_type\\\":1}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"right\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"Footer\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":12,\\\"column_type\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]}]\",\"menu\":\"single-page-menu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"single-page-menu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"200X200\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"show_list_tags\":\"1\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"author_info\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disqus\",\"comment_categories\":[\"2\",\"8\",\"9\",\"10\",\"11\",\"12\"],\"comment_disqus_subdomain\":\"localhost-codgjub77d\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"16\",\"template\":\"solari\",\"client_id\":\"0\",\"home\":\"0\",\"title\":\"Solari - Default - One Page\"}'),
('17', 'solari', '0', '0', 'Solari - Home Renewable Energy - One Page', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo\\/logo-01.svg\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"30px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/fav.png\",\"header_style\":\"\",\"header_height\":\"80px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"1335\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"\",\"contact_mobile\":\"\",\"contact_email\":\"\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-08-15 00:33:14\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset1\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#4AAB3D\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"2+6+4\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"header\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":6,\\\"sm_col\\\":6,\\\"md_col\\\":6,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"logo\\\",\\\"column_type\\\":0,\\\"grid_size\\\":2}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":3,\\\"sm_col\\\":3,\\\"md_col\\\":4,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"menu\\\",\\\"column_type\\\":0,\\\"grid_size\\\":6}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":3,\\\"sm_col\\\":3,\\\"md_col\\\":2,\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"sticky_position\\\":0,\\\"name\\\":\\\"position2\\\",\\\"column_type\\\":0,\\\"grid_size\\\":4}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"hide_mobile\\\":1,\\\"hide_large_mobile\\\":1,\\\"hide_tablet\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":12,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"title\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"Main Body\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"left\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"column_type\\\":1}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"right\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"Footer\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":12,\\\"column_type\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]}]\",\"menu\":\"single-page-menu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"single-page-menu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"200X200\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"show_list_tags\":\"1\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"author_info\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disqus\",\"comment_categories\":[\"2\",\"8\",\"9\",\"10\",\"11\",\"12\"],\"comment_disqus_subdomain\":\"localhost-codgjub77d\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"#sp-header:not(.header-sticky) {\\r\\nposition: absolute;\\r\\npadding: 32px 0px;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .logo {\\r\\n\\tpadding: 0;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .logo img {\\r\\nfilter: invert() brightness(10);\\r\\n}\\r\\n\\r\\n#sp-header .sp-megamenu-parent {\\r\\n\\ttext-align: left;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .sp-megamenu-parent > li > a, #sp-header:not(.header-sticky) .sp-megamenu-parent > li > span, #sp-header:not(.header-sticky) .sp-megamenu-parent > li:last-child > a {\\r\\n\\tcolor: #fff;\\r\\n}\\r\\n\\r\\n#sp-header.header-sticky #sp-position2 .sppb-addon-text-block rect {\\r\\n  fill: var(--maincolor) !important;\\r\\n}\\r\\n\\r\\n#sp-header.header-sticky #sp-position2 .sppb-btn-link {\\r\\ncolor: var(--maincolor);\\r\\n}\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"17\",\"template\":\"solari\",\"client_id\":\"0\",\"home\":\"0\",\"title\":\"Solari - Home Renewable Energy - One Page\"}'),
('18', 'solari', '0', '0', 'Solari - Home Hydro Power & Solar Solution - One Page', '0', '', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo\\/logo-01.svg\",\"retina_logo\":\"\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"30px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"images\\/fav.png\",\"header_style\":\"\",\"header_height\":\"80px\",\"header_height_sm\":\"\",\"header_height_xs\":\"50px\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"1335\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"default\",\"facebook\":\"\",\"twitter\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"\",\"contact_mobile\":\"\",\"contact_email\":\"\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2024-08-15 00:33:14\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#0345BF\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset1\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0345BF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0345BF\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_text_active_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0345BF\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0345BF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#ec430f\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset2\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ec430f\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ec430f\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_text_active_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ec430f\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ec430f\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#0fa89d\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset3\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#0fa89d\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#0fa89d\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_text_active_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0fa89d\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0fa89d\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#4943ac\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset4\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4943ac\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4943ac\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_text_active_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4943ac\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4943ac\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset5\\\":{\\\"label\\\":\\\"Preset 5\\\",\\\"default\\\":\\\"#00aeef\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset5\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#00aeef\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#00aeef\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_text_active_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#00aeef\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#00aeef\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset6\\\":{\\\"label\\\":\\\"Preset 6\\\",\\\"default\\\":\\\"#f68e13\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset6\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#f68e13\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#f68e13\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_text_active_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f68e13\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f68e13\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset7\\\":{\\\"label\\\":\\\"Preset 7\\\",\\\"default\\\":\\\"#2ba84a\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset7\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#2ba84a\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#2ba84a\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_text_active_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#2ba84a\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#2ba84a\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset8\\\":{\\\"label\\\":\\\"Preset 8\\\",\\\"default\\\":\\\"#ed145b\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset8\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#ed145b\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#ed145b\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_text_active_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#ed145b\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#ed145b\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}},\\\"preset9\\\":{\\\"label\\\":\\\"Preset 9\\\",\\\"default\\\":\\\"#4AAB3D\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#FFFFFF\\\",\\\"footer_link_color\\\":\\\"#A2A2A2\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#171717\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_dropdown_text_color\\\":\\\"#252525\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_hover_color\\\":\\\"#4AAB3D\\\",\\\"menu_text_color\\\":\\\"#252525\\\",\\\"logo_text_color\\\":\\\"#4AAB3D\\\",\\\"topbar_text_color\\\":\\\"#AAAAAA\\\",\\\"topbar_bg_color\\\":\\\"#333333\\\",\\\"header_bg_color\\\":\\\"#FFFFFF\\\",\\\"link_hover_color\\\":\\\"#044CD0\\\",\\\"link_color\\\":\\\"#4AAB3D\\\",\\\"bg_color\\\":\\\"#FFFFFF\\\",\\\"text_color\\\":\\\"#252525\\\",\\\"preset\\\":\\\"preset9\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+6+3\\\",\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"header\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":3,\\\"column_type\\\":0,\\\"name\\\":\\\"logo\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":6,\\\"sm_col\\\":6,\\\"xs_col\\\":6,\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":6,\\\"column_type\\\":0,\\\"name\\\":\\\"menu\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":4,\\\"sm_col\\\":3,\\\"xs_col\\\":3,\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"position2\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":2,\\\"sm_col\\\":3,\\\"xs_col\\\":3,\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"grid_size\\\":3}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"hide_mobile\\\":1,\\\"hide_large_mobile\\\":1,\\\"hide_tablet\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":12,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"title\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"Main Body\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"left\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"column_type\\\":1}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"right\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_ex_large_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"Footer\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":12,\\\"column_type\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\"}}]}]\",\"menu\":\"single-page-menu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"1-LeftAlign\",\"offcanvas_menu\":\"single-page-menu\",\"offcanvas_max_level\":\"0\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"800\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"200X200\",\"image_small_size\":\"100X100\",\"image_medium_size\":\"300X300\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"large\",\"show_list_tags\":\"1\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"author_info\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disqus\",\"comment_categories\":[\"2\",\"8\",\"9\",\"10\",\"11\",\"12\"],\"comment_disqus_subdomain\":\"localhost-codgjub77d\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"#sp-header {\\r\\nposition: absolute;\\r\\npadding: 32px 0px;\\r\\n}\\r\\n\\r\\n#sp-header.header-sticky {\\r\\n\\tbackground: #1B1B1B;\\r\\npadding: 0px;\\r\\n}\\r\\n\\r\\n#sp-header:not(.header-sticky) .logo {\\r\\n\\tpadding: 0;\\r\\n}\\r\\n\\r\\n#sp-header .logo img {\\r\\nfilter: invert() brightness(10);\\r\\n}\\r\\n\\r\\n#sp-header .sp-megamenu-parent > li > a, #sp-header .sp-megamenu-parent > li > span, #sp-header .sp-megamenu-parent > li:last-child > a {\\r\\n\\tcolor: #fff;\\r\\n}\",\"custom_js\":\"\",\"exclude_js\":\"\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"\",\"id\":\"18\",\"template\":\"solari\",\"client_id\":\"0\",\"home\":\"0\",\"title\":\"Solari - Home Hydro Power & Solar Solution - One Page\"}');/**ABDB**/
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `hash_id` varchar(255) NOT NULL DEFAULT '',
  `extension_id` int(11) DEFAULT 0,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `action` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) unsigned NOT NULL DEFAULT 0,
  `path` varchar(400) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT 1,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '19', '0', '', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '', '', '', '', '19', '2024-08-15 00:00:51', '', '19', '2024-08-15 00:00:51', '', '', '0', '*', '1', NULL, NULL),
('2', '1', '1', '2', '1', 'services', 'Services', 'services', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:42:16', '', '19', '2024-08-18 22:42:16', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('3', '1', '3', '4', '1', 'business', 'Business', 'business', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:42:30', '', '19', '2024-08-18 22:42:30', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('4', '1', '5', '6', '1', 'growth', 'Growth', 'growth', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:42:38', '', '19', '2024-08-18 22:42:38', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('5', '1', '7', '8', '1', 'finance', 'Finance', 'finance', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:42:43', '', '19', '2024-08-18 22:42:43', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('6', '1', '9', '10', '1', 'ui-ux-design', 'UI/UX Design', 'ui-ux-design', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:42:59', '', '19', '2024-08-18 22:42:59', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('7', '1', '11', '12', '1', 'solution', 'Solution', 'solution', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:43:11', '', '19', '2024-08-18 22:43:11', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('8', '1', '13', '14', '1', 'speed', 'Speed', 'speed', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:43:18', '', '19', '2024-08-18 22:43:18', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('9', '1', '15', '16', '1', 'strategy', 'Strategy', 'strategy', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:43:28', '', '19', '2024-08-18 22:43:28', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL),
('10', '1', '17', '18', '1', 'technology', 'Technology', 'technology', '', '', '1', NULL, NULL, '1', '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '19', '2024-08-18 22:43:37', '', '19', '2024-08-18 22:43:37', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', '0', '*', '1', NULL, NULL);
/**ABDB**/CREATE TABLE `#__sppagebuilder_sections` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `section` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_presets` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `addon_name` varchar(255) NOT NULL DEFAULT '',
  `preset` mediumtext NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_languages` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_integrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL DEFAULT '',
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_image_shapes` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `shape` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_fonts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `family_name` varchar(100) NOT NULL DEFAULT '',
  `data` text DEFAULT NULL,
  `type` enum('google','local') DEFAULT 'google',
  `created` datetime NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `family_name` (`family_name`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__sppagebuilder_fonts`  VALUES 
('1', 'Exo', '{\"type\":\"google\",\"family\":\"Exo\",\"variants\":[\"100\",\"200\",\"300\",\"regular\",\"500\",\"600\",\"700\",\"800\",\"900\",\"100italic\",\"200italic\",\"300italic\",\"italic\",\"500italic\",\"600italic\",\"700italic\",\"800italic\",\"900italic\"],\"installed_variants\":[],\"category\":\"\",\"is_installed\":false}', 'google', '2024-08-15 00:29:19', '19', '1'),
('2', 'Albert Sans', '{\"type\":\"google\",\"family\":\"Albert Sans\",\"variants\":[\"100\",\"200\",\"300\",\"regular\",\"500\",\"600\",\"700\",\"800\",\"900\",\"100italic\",\"200italic\",\"300italic\",\"italic\",\"500italic\",\"600italic\",\"700italic\",\"800italic\",\"900italic\"],\"installed_variants\":[],\"category\":\"\",\"is_installed\":false}', 'google', '2024-08-15 00:29:42', '19', '1');
/**ABDB**/CREATE TABLE `#__sppagebuilder_colors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `colors` text DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_assets` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `assets` text NOT NULL,
  `css_path` text DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT current_timestamp(),
  `created_by` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_addons` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `code` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder_addonlist` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `ordering` int(5) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `is_favorite` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `content` mediumtext DEFAULT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `catid` int(10) NOT NULL DEFAULT 0,
  `access` int(10) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created_on` datetime NOT NULL,
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` bigint(20) NOT NULL DEFAULT 0,
  `checked_out` int(10) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint(20) NOT NULL DEFAULT 0,
  `css` longtext NOT NULL,
  `version` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('1', '102', 'Home Wind Energy', '[]', '[{\"id\":\"92cd955c-e82d-40da-986e-21356c0b5d96\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":\"f9d5d3af-4a63-474c-83c7-c35cb5f924d4\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"73f6a179-84a4-4316-9a1e-72eb44f25fe8\",\"type\":\"repeatable\",\"name\":\"js_slideshow\",\"visibility\":true,\"title\":\"Slideshow\",\"icon\":\"<svg viewbox=\\\"0 0 32 32\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M17.656 10.518a1.138 1.138 0 1 0 0 2.276 1.138 1.138 0 0 0 0-2.276ZM15 11.656a2.656 2.656 0 1 1 5.312 0 2.656 2.656 0 0 1-5.312 0ZM10 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm12 0a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm-6.636-9.909c.885.842 1.854 1.306 2.88 1.345 1.014.038 1.939-.343 2.738-.91 1.563-1.108 2.888-3.095 3.906-5.067l-1.776-.918c-.985 1.906-2.13 3.533-3.287 4.354-.561.398-1.06.56-1.505.543-.433-.017-.96-.207-1.578-.796-1.163-1.106-2.319-1.737-3.458-1.923-1.157-.188-2.186.101-3.042.63-1.648 1.018-2.698 2.941-3.185 4.318l1.886.666c.42-1.19 1.265-2.612 2.35-3.282.511-.316 1.058-.457 1.67-.358.628.102 1.432.477 2.4 1.398Z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M9 8h14v11H9V8ZM7 8a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2v11a2 2 0 0 1-2 2H9a2 2 0 0 1-2-2V8Zm-2.193 2.591A1 1 0 1 0 3.193 9.41L.236 13.444a1.246 1.246 0 0 0 0 1.46l2.703 3.687a1 1 0 1 0 1.613-1.182L2.18 14.174l2.626-3.583ZM16 27a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM27.409 9.193a1 1 0 0 1 1.398.216l2.957 4.035c.315.43.315 1.03 0 1.46l-2.703 3.687a1 1 0 1 1-1.613-1.182l2.371-3.235-2.626-3.583a1 1 0 0 1 .216-1.398Z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\".water-text {\\n\\tposition: absolute;\\n\\tleft: 10%;\\n\\ttop: 25%;\\n\\tz-index: 0;\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(255, 255, 255, 0.1);\\n}\\n\\n.pre span {\\n\\tbackground: var(--maincolor);\\n\\tpadding: 2px 7px;\\n\\tborder-radius: 2px;\\n}\\n\\n.vedio-icone {\\ndisplay: inline-block;\\n}\\n\\n.vedio-icone .video-play-button {\\ndisplay: flex;\\nalign-items: center;\\ngap: 15px;\\n}\\n\\n.vedio-icone .video-play-button .sppb-modal-icon-wrap {\\n\\twidth: 80px;\\n\\theight: 80px;\\n\\tborder-radius: 50%;\\n\\tdisplay: flex;\\nalign-items: center;\\njustify-content: center;\\n}\\n\\n.vedio-icone .video-play-button .sppb-modal-icon-wrap:before {\\n\\tcontent: \\\"\\\";\\n\\tposition: absolute;\\n\\tz-index: 0;\\n\\tleft: -32%;\\n\\ttop: -31%;\\n\\tdisplay: block;\\n\\twidth: 130px;\\n\\theight: 130px;\\n\\tbackground: transparent;\\n\\tborder-radius: 50%;\\n\\tborder: 1px solid var(--maincolor);\\n\\tanimation: waves 3s ease-in-out infinite;\\nbackground: #ffffff62;\\n  border: transparent;\\n  border-color: #fff;\\n}\\n\\n.vedio-icone .video-play-button .sppb-modal-icon-wrap:after {\\n\\tcontent: \\\"\\\";\\n\\tposition: absolute;\\n\\tz-index: 1;\\n\\tleft: 50%;\\n\\ttop: 50%;\\n\\ttransform: translateX(-50%) translateY(-50%);\\n\\tdisplay: block;\\n\\twidth: 60px;\\n\\theight: 60px;\\n\\tbackground: transparent;\\n\\tborder: 2px solid var(--maincolor);\\n\\ttransition: all 200ms;\\n\\tborder-radius: 50%;\\nbackground: #fff;\\n  border: transparent;\\n}\\n\\n.vedio-icone .video-play-button .sppb-modal-icon-wrap i {\\ncolor: var(--maincolor);\\nposition: relative;\\nz-index: 3;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"slideshow_items\":[{\"slider_img\":{\"src\":\"images\\/banner\\/08.jpg\",\"alt\":\"\",\"height\":877,\"width\":1920},\"content_alignment\":\"left\",\"slider_bg_options\":\"bg_image\",\"slideshow_inner_items\":[{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<p>Wind<\\/p>\",\"content_class\":\"water-text\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"200\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"90\",\"unit\":\"px\"},\"xs\":{\"value\":\"60\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"var(--color-body)\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Back Text\",\"content_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":{\"xl\":\"0px 0px -30px 0px\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<span>Welcome<\\/span> To Solari\",\"content_class\":\"pre\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.08\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Pre Title\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"title_content_title\":\"Harnessing the Wind and Sun for Future\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h1\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 1\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"55\",\"unit\":\"px\"},\"md\":{\"value\":\"50\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"40\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"65\",\"unit\":\"px\"},\"md\":{\"value\":\"60\",\"unit\":\"px\"},\"sm\":{\"value\":\"55\",\"unit\":\"px\"},\"xs\":{\"value\":\"50\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Title\",\"content_margin\":{\"xl\":\"25px 0px 0px 0px\"}},{\"content_text\":\"In a world where renewable resources have become paramount <br> we believe in the boundless power of nature to shape.\",\"content_type\":\"text_content\",\"content_color\":\"#fff\",\"content_fontsize\":{\"xl\":20,\"lg\":20,\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 2\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":20,\"unit\":\"px\"},\"md\":{\"value\":20,\"unit\":\"px\"},\"sm\":{\"value\":16,\"unit\":\"px\"},\"xs\":{\"value\":14,\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"28\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Content\",\"content_margin\":{\"xl\":\"25px 0px 40px 0px\"}},{\"btn_content\":\"Learn More\",\"content_type\":\"btn_content\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 3\",\"content_class\":\"\",\"button_url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=139\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Button\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<a class=\\\"sppb-magnific-popup video-play-button play-video\\\" href=\\\"https:\\/\\/www.youtube.com\\/watch?v=MuHB_aHOyp4\\\" data-popup_type=\\\"iframe\\\" data-mainclass=\\\"mfp-no-margins mfp-with-zoom\\\"><span class=\\\"sppb-modal-icon-wrap\\\"><i class=\\\"fas fa-play\\\" aria-hidden=\\\"true\\\"><\\/i><\\/span><span class=\\\"text\\\">Intro Video<\\/span><\\/a>\",\"content_class\":\"vedio-icone\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":\"\",\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Video Popup\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"}],\"admin_label\":\"Item 1\",\"title\":\"\",\"slider_overlay_options\":\"color_overlay\",\"image_in_column\":1,\"image_column_width\":{\"xl\":\"6\",\"md\":\"12\",\"sm\":\"12\",\"xs\":\"12\"},\"repeatable\":{\"field_name\":\"slideshow_inner_items\",\"field_value\":[{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<p>Wind<\\/p>\",\"content_class\":\"water-text\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"200\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"90\",\"unit\":\"px\"},\"xs\":{\"value\":\"60\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"var(--color-body)\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Back Text\",\"content_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":{\"xl\":\"0px 0px -30px 0px\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<span>Welcome<\\/span> To Solari\",\"content_class\":\"pre\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.08\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Pre Title\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"title_content_title\":\"Harnessing the Wind and Sun for Future\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h1\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 1\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"55\",\"unit\":\"px\"},\"md\":{\"value\":\"50\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"40\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"65\",\"unit\":\"px\"},\"md\":{\"value\":\"60\",\"unit\":\"px\"},\"sm\":{\"value\":\"55\",\"unit\":\"px\"},\"xs\":{\"value\":\"50\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Title\",\"content_margin\":{\"xl\":\"25px 0px 0px 0px\"}},{\"content_text\":\"In a world where renewable resources have become paramount <br> we believe in the boundless power of nature to shape.\",\"content_type\":\"text_content\",\"content_color\":\"#fff\",\"content_fontsize\":{\"xl\":20,\"lg\":20,\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 2\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":20,\"unit\":\"px\"},\"md\":{\"value\":20,\"unit\":\"px\"},\"sm\":{\"value\":16,\"unit\":\"px\"},\"xs\":{\"value\":14,\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"28\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Content\",\"content_margin\":{\"xl\":\"25px 0px 40px 0px\"}},{\"btn_content\":\"Learn More\",\"content_type\":\"btn_content\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 3\",\"content_class\":\"\",\"button_url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=139\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Button\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<a class=\\\"sppb-magnific-popup video-play-button play-video\\\" href=\\\"https:\\/\\/www.youtube.com\\/watch?v=MuHB_aHOyp4\\\" data-popup_type=\\\"iframe\\\" data-mainclass=\\\"mfp-no-margins mfp-with-zoom\\\"><span class=\\\"sppb-modal-icon-wrap\\\"><i class=\\\"fas fa-play\\\" aria-hidden=\\\"true\\\"><\\/i><\\/span><span class=\\\"text\\\">Intro Video<\\/span><\\/a>\",\"content_class\":\"vedio-icone\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":\"\",\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Video Popup\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"}]}},{\"slider_img\":{\"src\":\"images\\/banner\\/13.jpg\",\"alt\":\"\",\"height\":877,\"width\":1920},\"content_alignment\":\"left\",\"slider_bg_options\":\"bg_image\",\"slideshow_inner_items\":[{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<p>Wind<\\/p>\",\"content_class\":\"water-text\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"200\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"90\",\"unit\":\"px\"},\"xs\":{\"value\":\"60\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"var(--color-body)\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Back Text\",\"content_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":{\"xl\":\"0px 0px -30px 0px\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<span>Welcome<\\/span> To Solari\",\"content_class\":\"pre\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.08\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Pre Title\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"title_content_title\":\"Harnessing the Wind and Sun for Future\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h1\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 1\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"55\",\"unit\":\"px\"},\"md\":{\"value\":\"50\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"40\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"65\",\"unit\":\"px\"},\"md\":{\"value\":\"60\",\"unit\":\"px\"},\"sm\":{\"value\":\"55\",\"unit\":\"px\"},\"xs\":{\"value\":\"50\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Title\",\"content_margin\":{\"xl\":\"25px 0px 0px 0px\"}},{\"content_text\":\"In a world where renewable resources have become paramount <br> we believe in the boundless power of nature to shape.\",\"content_type\":\"text_content\",\"content_color\":\"#fff\",\"content_fontsize\":{\"xl\":20,\"lg\":20,\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 2\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":20,\"unit\":\"px\"},\"md\":{\"value\":20,\"unit\":\"px\"},\"sm\":{\"value\":16,\"unit\":\"px\"},\"xs\":{\"value\":14,\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"28\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Content\",\"content_margin\":{\"xl\":\"25px 0px 40px 0px\"}},{\"btn_content\":\"Learn More\",\"content_type\":\"btn_content\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 3\",\"content_class\":\"\",\"button_url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=139\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Button\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<a class=\\\"sppb-magnific-popup video-play-button play-video\\\" href=\\\"https:\\/\\/www.youtube.com\\/watch?v=MuHB_aHOyp4\\\" data-popup_type=\\\"iframe\\\" data-mainclass=\\\"mfp-no-margins mfp-with-zoom\\\"><span class=\\\"sppb-modal-icon-wrap\\\"><i class=\\\"fas fa-play\\\" aria-hidden=\\\"true\\\"><\\/i><\\/span><span class=\\\"text\\\">Intro Video<\\/span><\\/a>\",\"content_class\":\"vedio-icone\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":\"\",\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Video Popup\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"}],\"admin_label\":\"Item 1 copy\",\"title\":\"\",\"slider_overlay_options\":\"color_overlay\",\"image_in_column\":1,\"image_column_width\":{\"xl\":\"6\",\"md\":\"12\",\"sm\":\"12\",\"xs\":\"12\"},\"repeatable\":{\"field_name\":\"slideshow_inner_items\",\"field_value\":[{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<p>Wind<\\/p>\",\"content_class\":\"water-text\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"200\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"90\",\"unit\":\"px\"},\"xs\":{\"value\":\"60\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"var(--color-body)\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Back Text\",\"content_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":{\"xl\":\"0px 0px -30px 0px\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<span>Welcome<\\/span> To Solari\",\"content_class\":\"pre\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.08\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Pre Title\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"title_content_title\":\"Harnessing the Wind and Sun for Future\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h1\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 1\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"55\",\"unit\":\"px\"},\"md\":{\"value\":\"50\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"40\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"65\",\"unit\":\"px\"},\"md\":{\"value\":\"60\",\"unit\":\"px\"},\"sm\":{\"value\":\"55\",\"unit\":\"px\"},\"xs\":{\"value\":\"50\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Title\",\"content_margin\":{\"xl\":\"25px 0px 0px 0px\"}},{\"content_text\":\"In a world where renewable resources have become paramount <br> we believe in the boundless power of nature to shape.\",\"content_type\":\"text_content\",\"content_color\":\"#fff\",\"content_fontsize\":{\"xl\":20,\"lg\":20,\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 2\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":20,\"unit\":\"px\"},\"md\":{\"value\":20,\"unit\":\"px\"},\"sm\":{\"value\":16,\"unit\":\"px\"},\"xs\":{\"value\":14,\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"28\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Content\",\"content_margin\":{\"xl\":\"25px 0px 40px 0px\"}},{\"btn_content\":\"Learn More\",\"content_type\":\"btn_content\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 3\",\"content_class\":\"\",\"button_url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=139\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Button\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<a class=\\\"sppb-magnific-popup video-play-button play-video\\\" href=\\\"https:\\/\\/www.youtube.com\\/watch?v=MuHB_aHOyp4\\\" data-popup_type=\\\"iframe\\\" data-mainclass=\\\"mfp-no-margins mfp-with-zoom\\\"><span class=\\\"sppb-modal-icon-wrap\\\"><i class=\\\"fas fa-play\\\" aria-hidden=\\\"true\\\"><\\/i><\\/span><span class=\\\"text\\\">Intro Video<\\/span><\\/a>\",\"content_class\":\"vedio-icone\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":\"\",\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Video Popup\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"}]}},{\"slider_img\":{\"src\":\"images\\/banner\\/14.jpg\",\"alt\":\"\",\"height\":877,\"width\":1920},\"content_alignment\":\"left\",\"slider_bg_options\":\"bg_image\",\"slideshow_inner_items\":[{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<p>Wind<\\/p>\",\"content_class\":\"water-text\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"200\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"90\",\"unit\":\"px\"},\"xs\":{\"value\":\"60\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"var(--color-body)\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Back Text\",\"content_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":{\"xl\":\"0px 0px -30px 0px\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<span>Welcome<\\/span> To Solari\",\"content_class\":\"pre\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.08\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Pre Title\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"title_content_title\":\"Harnessing the Wind and Sun for Future\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h1\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 1\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"55\",\"unit\":\"px\"},\"md\":{\"value\":\"50\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"40\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"65\",\"unit\":\"px\"},\"md\":{\"value\":\"60\",\"unit\":\"px\"},\"sm\":{\"value\":\"55\",\"unit\":\"px\"},\"xs\":{\"value\":\"50\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Title\",\"content_margin\":{\"xl\":\"25px 0px 0px 0px\"}},{\"content_text\":\"In a world where renewable resources have become paramount <br> we believe in the boundless power of nature to shape.\",\"content_type\":\"text_content\",\"content_color\":\"#fff\",\"content_fontsize\":{\"xl\":20,\"lg\":20,\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 2\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":20,\"unit\":\"px\"},\"md\":{\"value\":20,\"unit\":\"px\"},\"sm\":{\"value\":16,\"unit\":\"px\"},\"xs\":{\"value\":14,\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"28\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Content\",\"content_margin\":{\"xl\":\"25px 0px 40px 0px\"}},{\"btn_content\":\"Learn More\",\"content_type\":\"btn_content\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 3\",\"content_class\":\"\",\"button_url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=139\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Button\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<a class=\\\"sppb-magnific-popup video-play-button play-video\\\" href=\\\"https:\\/\\/www.youtube.com\\/watch?v=MuHB_aHOyp4\\\" data-popup_type=\\\"iframe\\\" data-mainclass=\\\"mfp-no-margins mfp-with-zoom\\\"><span class=\\\"sppb-modal-icon-wrap\\\"><i class=\\\"fas fa-play\\\" aria-hidden=\\\"true\\\"><\\/i><\\/span><span class=\\\"text\\\">Intro Video<\\/span><\\/a>\",\"content_class\":\"vedio-icone\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":\"\",\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Video Popup\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"}],\"admin_label\":\"Item 1 copy\",\"title\":\"\",\"slider_overlay_options\":\"color_overlay\",\"image_in_column\":1,\"image_column_width\":{\"xl\":\"6\",\"md\":\"12\",\"sm\":\"12\",\"xs\":\"12\"},\"repeatable\":{\"field_name\":\"slideshow_inner_items\",\"field_value\":[{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<p>Wind<\\/p>\",\"content_class\":\"water-text\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"200\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"90\",\"unit\":\"px\"},\"xs\":{\"value\":\"60\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"var(--color-body)\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Back Text\",\"content_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":{\"xl\":\"0px 0px -30px 0px\"},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<span>Welcome<\\/span> To Solari\",\"content_class\":\"pre\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.08\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Pre Title\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"},{\"title_content_title\":\"Harnessing the Wind and Sun for Future\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h1\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 1\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"60\",\"unit\":\"px\"},\"lg\":{\"value\":\"55\",\"unit\":\"px\"},\"md\":{\"value\":\"50\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"40\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"70\",\"unit\":\"px\"},\"lg\":{\"value\":\"65\",\"unit\":\"px\"},\"md\":{\"value\":\"60\",\"unit\":\"px\"},\"sm\":{\"value\":\"55\",\"unit\":\"px\"},\"xs\":{\"value\":\"50\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Title\",\"content_margin\":{\"xl\":\"25px 0px 0px 0px\"}},{\"content_text\":\"In a world where renewable resources have become paramount <br> we believe in the boundless power of nature to shape.\",\"content_type\":\"text_content\",\"content_color\":\"#fff\",\"content_fontsize\":{\"xl\":20,\"lg\":20,\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 2\",\"content_class\":\"\",\"content_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":20,\"unit\":\"px\"},\"md\":{\"value\":20,\"unit\":\"px\"},\"sm\":{\"value\":16,\"unit\":\"px\"},\"xs\":{\"value\":14,\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"28\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"Content\",\"content_margin\":{\"xl\":\"25px 0px 40px 0px\"}},{\"btn_content\":\"Learn More\",\"content_type\":\"btn_content\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"admin_label\":\"Item 3\",\"content_class\":\"\",\"button_url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=139\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Button\"},{\"content_type\":\"text_content\",\"title_content_title\":\"The Amazing Slideshow Addon!\",\"title_heading_selector\":\"h2\",\"content_text\":\"<a class=\\\"sppb-magnific-popup video-play-button play-video\\\" href=\\\"https:\\/\\/www.youtube.com\\/watch?v=MuHB_aHOyp4\\\" data-popup_type=\\\"iframe\\\" data-mainclass=\\\"mfp-no-margins mfp-with-zoom\\\"><span class=\\\"sppb-modal-icon-wrap\\\"><i class=\\\"fas fa-play\\\" aria-hidden=\\\"true\\\"><\\/i><\\/span><span class=\\\"text\\\">Intro Video<\\/span><\\/a>\",\"content_class\":\"vedio-icone\",\"image_content\":{\"src\":\"\"},\"icon_content\":\"fa-cogs\",\"btn_content\":\"Learn More\",\"button_url\":\"\",\"button_icon_separator\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"left\",\"button_icon_margin\":\"\",\"style_separator\":\"\",\"content_typography\":\"\",\"content_color\":\"#fff\",\"button_hover_color\":\"#fff\",\"content_background\":\"\",\"image_content_style_separator\":\"\",\"image_content_width\":{\"xl\":400,\"sm\":\"\"},\"image_content_height\":{\"xl\":385,\"sm\":\"\"},\"button_background_options\":\"color_bg\",\"button_background_color\":\"#444444\",\"button_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"button_background_color_hover\":\"#222\",\"button_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"title_separator\":\"\",\"title\":\"Video Popup\",\"content_text_shadow\":\"0 0 0 #ffffff\",\"btn_box_shadow\":\"0 0 0 0 #ffffff\",\"content_border_separator\":\"\",\"content_border\":\"\",\"content_border_color\":\"\",\"button_hover_border_color\":\"#fff\",\"content_border_radius\":\"\",\"content_spacing_separator\":\"\",\"content_padding\":\"\",\"content_margin\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"bottom\",\"animation_duration\":\"800\",\"animation_delay\":\"1000\",\"animation_slide_from\":\"100\",\"animation_rotate_from\":\"360\",\"animation_rotate_to\":\"0\",\"animation_timing_function\":\"ease\",\"animation_cubic_bezier_value\":\"0,0.46,0,0.63\"}]}}],\"content_container_option\":\"bootstrap\",\"content_container_width\":{\"xl\":75},\"content_vertical_alignment\":1,\"height\":\"custom\",\"custom_height\":{\"xl\":\"825\",\"lg\":900,\"md\":900,\"sm\":\"700\",\"xs\":\"750\"},\"slider_animation\":\"bubble\",\"slide_vertically\":0,\"three_d_rotate\":15,\"autoplay\":1,\"pause_on_hover\":0,\"interval\":\"5\",\"speed\":\"800\",\"timer\":0,\"timer_bg_color\":\"\",\"timer_color\":\"\",\"timer_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"timer_top_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"timer_left_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"slide_counter\":0,\"slide_counter_fontsize\":{\"xl\":22},\"slide_counter_padding\":\"0px 0px 0px 0px\",\"slide_counter_gap_bottom\":{\"xl\":20},\"slide_counter_gap_left\":{\"xl\":20},\"dot_controllers\":1,\"dot_controllers_style\":\"dot\",\"line_indecator\":1,\"dot_controllers_position\":\"vertical_left\",\"dot_controllers_bottom_gap\":{\"xl\":50},\"dot_controllers_left_gap\":{\"xl\":50,\"md\":\"0\",\"sm\":\"0\",\"xs\":\"0\"},\"dot_controllers_right_gap\":{\"xl\":50},\"dot_controller_style_option\":\"dot_normal\",\"dot_ctlr_height\":\"10\",\"dot_ctlr_width\":\"10\",\"dot_ctlr_bg\":\"\",\"dot_ctlr_border_width\":\"0\",\"dot_ctlr_border_color\":\"\",\"dot_ctlr_border_radius\":\"100\",\"dot_ctlr_margin\":\"\",\"dot_ctlr_hover_height\":\"10\",\"dot_ctlr_hover_width\":\"10\",\"dot_ctlr_center_bg\":\"\",\"dot_ctlr_hover_border_color\":\"\",\"arrow_controllers\":0,\"arrow_on_hover\":0,\"arrow_controllers_style\":\"spread\",\"arrow_controllers_content\":\"icon_only\",\"arrow_controllers_position\":\"bottom_center\",\"arrow_controllers_bottom_gap\":{\"xl\":50},\"arrow_controllers_left_gap\":{\"xl\":50},\"arrow_controllers_right_gap\":{\"xl\":50},\"arrow_spread_controllers_left_gap\":{\"xl\":50},\"arrow_spread_controllers_right_gap\":{\"xl\":50},\"arrow_ctlr_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_height\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_ctlr_font_size\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"arrow_style\":\"arrow_normal\",\"arrow_ctlr_color\":\"\",\"arrow_ctlr_background\":\"\",\"arrow_ctlr_border_width\":\"\",\"arrow_ctlr_border_color\":\"\",\"arrow_ctlr_border_radius\":\"50\",\"arrow_ctlr_hover_color\":\"\",\"arrow_ctlr_hover_background\":\"\",\"arrow_ctlr_hover_border_color\":\"\",\"text_thumb_number_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"text_thumb_title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"text_thumb_subtitle_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}}}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":false},{\"id\":\"ae0a4e2f-eaee-47a4-8315-873473b28d72\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"-160px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"-100px 0px 0px 0px\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"3+3+3+3\",\"columns\":[{\"id\":\"b702d216-bd7a-4f7d-ad6e-7ea4b84921e6\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"d2d9b5d6-522e-4a6f-a946-517ade75bd7e\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/19.png\",\"alt\":\"\",\"height\":240,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.04)\",\"ho\":0,\"vo\":\"10\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-service-solari\",\"global_custom_css\":\".single-service-solari::before {\\n\\tposition: absolute;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\tbackground: #1b1b1b86;\\n\\tcontent: \\\"\\\";\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tborder-radius: 10px;\\n\\tz-index: -1;\\n}\\n\\n.single-service-solari::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tbackground: #fff;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\ttransition: 0.3s;\\n\\tz-index: -1;\\n\\tborder-radius: 10px;\\n}\\n\\n.single-service-solari .icon-area svg path {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .disc {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-service-solari:hover .icon-area svg path {\\n\\tfill: #fff;\\n}\\n\\n.single-service-solari:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-service-solari .title .sppb-addon-title:hover {\\ncolor: var(--maincolor);\\n}\\n\\n.single-service-solari:hover .disc {\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Single Service\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_text_color\":\"#74787C\",\"global_addon_z_index\":\"2\"},\"children\":[\"6c717061-8908-4866-a677-68ab8ed5abde\",\"8c2feaf7-30a9-4cee-afde-da0af55c4a7d\",\"20a50def-7d0e-44f1-b1c5-d5977c0c8b36\"]},{\"id\":\"6c717061-8908-4866-a677-68ab8ed5abde\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 26px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"60\\\" height=\\\"60\\\" viewBox=\\\"0 0 60 60\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<circle cx=\\\"30\\\" cy=\\\"30\\\" r=\\\"29.5\\\" stroke=\\\"#E9E9E9\\\"><\\/circle>\\n<path d=\\\"M30.7778 37.6112C30.8644 38.3254 30.6734 38.9772 30.2253 39.4961C29.6954 40.1099 28.8123 40.5206 27.8079 40.6337V41.4041C27.8079 41.7247 27.5483 41.9847 27.2282 41.9847C26.9081 41.9847 26.6485 41.7247 26.6485 41.4041V40.6254C25.1636 40.4254 24.0087 39.4877 23.6751 38.1475C23.5977 37.8364 23.7867 37.5212 24.0973 37.4437C24.4082 37.3665 24.7226 37.5555 24.8001 37.8666C25.0984 39.065 26.2674 39.494 27.2251 39.5036C27.2302 39.5036 27.2354 39.5037 27.2404 39.5038C27.2726 39.5036 27.3045 39.5036 27.3361 39.5028C28.1738 39.4829 28.9637 39.182 29.3484 38.7364C29.5832 38.4645 29.6743 38.1422 29.6269 37.7511C29.515 36.8282 28.7489 36.2988 27.1428 36.0347C24.6082 35.6179 24.0181 34.3323 23.9695 33.3272C23.902 31.9343 24.876 30.7668 26.3933 30.4221C26.4768 30.4031 26.5621 30.3869 26.6485 30.3736V29.5866C26.6485 29.2659 26.9081 29.0059 27.2282 29.0059C27.5483 29.0059 27.8079 29.2659 27.8079 29.5866V30.3686C28.8959 30.5264 29.9711 31.155 30.5071 32.4341C30.6311 32.7297 30.4923 33.0701 30.1971 33.1942C29.9019 33.3184 29.5621 33.1793 29.4382 32.8836C29.0218 31.8903 28.1308 31.487 27.271 31.4856C27.2473 31.4874 27.2228 31.4875 27.1988 31.4865C27.0118 31.491 26.8271 31.5144 26.6497 31.5547C25.8821 31.729 25.0791 32.2715 25.1275 33.2709C25.1427 33.584 25.1888 34.5366 27.3306 34.8888C28.1172 35.0182 30.5112 35.4118 30.7778 37.6112ZM44.767 41.2577L39.3435 47.6559C39.1554 47.8778 38.8919 47.9999 38.6013 47.9999C38.3108 47.9999 38.0472 47.8777 37.8592 47.656L35.6892 45.096C33.4534 46.9768 30.5715 48 27.4874 48C27.412 48 27.3367 47.9993 27.261 47.9982C27.1873 47.9994 27.1128 47.9999 27.0392 47.9999C22.5695 48.0001 18.5101 45.8121 16.404 42.2523C14.4928 39.0221 14.5346 35.1681 16.5186 31.6788C17.7604 29.4948 19.6623 27.0218 22.4681 23.9474C21.6712 23.5843 21.1154 22.7798 21.1154 21.8472C21.1154 20.5941 22.1187 19.5718 23.363 19.5424L21.5303 17.7068C20.614 16.7889 20.614 15.2955 21.5303 14.3777C22.3059 13.6008 23.5392 13.4682 24.4629 14.062C24.5621 14.1257 24.6592 14.1345 24.7682 14.0893C24.877 14.0442 24.9395 13.9693 24.9646 13.8539C25.1987 12.7798 26.1644 12.0001 27.2609 12C28.3575 12 29.3233 12.7796 29.5575 13.8537C29.5827 13.9693 29.6451 14.0442 29.7541 14.0894C29.8629 14.1345 29.9599 14.1257 30.0592 14.062C30.9829 13.4682 32.2161 13.6008 32.9917 14.3777C33.9081 15.2956 33.9081 16.7891 32.9918 17.7069L31.1592 19.5424C32.4034 19.572 33.4067 20.5942 33.4067 21.8474C33.4067 22.7799 32.8509 23.5844 32.054 23.9474C33.2361 25.2428 34.2544 26.4285 35.1307 27.5298C35.1958 26.8346 35.7811 26.2886 36.4917 26.2886H40.711C41.4651 26.2887 42.0786 26.9032 42.0785 27.6585V39.6516H44.0249C44.4088 39.6516 44.7474 39.8684 44.9084 40.2173C45.0695 40.5659 45.0154 40.9646 44.767 41.2577ZM22.3501 16.8856L25.0012 19.5409H29.5211L32.172 16.8856C32.6363 16.4205 32.6363 15.6639 32.172 15.1988C31.7791 14.8052 31.1539 14.7381 30.6855 15.0392C30.2688 15.3071 29.7675 15.3519 29.3104 15.1621C28.8531 14.9724 28.5304 14.5858 28.4248 14.1014C28.3061 13.5567 27.8166 13.1613 27.261 13.1613C26.7055 13.1614 26.2161 13.5568 26.0974 14.1014C25.9918 14.5858 25.669 14.9725 25.2117 15.1622C24.7544 15.3518 24.2532 15.307 23.8367 15.0393C23.3682 14.7381 22.743 14.8052 22.35 15.1988C21.8857 15.6639 21.8857 16.4206 22.3501 16.8856ZM22.2748 21.8472C22.2748 22.4786 22.7876 22.9923 23.4179 22.9923H31.1041C31.7344 22.9923 32.2472 22.4786 32.2472 21.8473C32.2472 21.2159 31.7344 20.7023 31.1041 20.7023H23.4179C22.7876 20.7022 22.2748 21.2159 22.2748 21.8472ZM34.9389 44.2109L32.4357 41.2578C32.1872 40.9645 32.1332 40.5657 32.2943 40.2169C32.4554 39.8681 32.794 39.6513 33.1779 39.6513H35.1242V29.4233C33.9731 27.872 32.5117 26.1443 30.6669 24.1536H23.8548C20.8147 27.4342 18.8003 30.0124 17.526 32.2536C15.7277 35.4161 15.6835 38.7569 17.4012 41.6603C19.3318 44.9234 23.1071 46.9064 27.2512 46.837C27.2577 46.8368 27.2642 46.8368 27.2707 46.837C30.1609 46.8865 32.861 45.9568 34.9389 44.2109ZM38.4601 46.9038C38.4599 46.904 38.4598 46.9042 38.4597 46.9043L38.4601 46.9038ZM43.6234 40.8127H41.4988C41.1787 40.8127 40.9191 40.5527 40.9191 40.2321V27.6583C40.9191 27.5452 40.8239 27.4497 40.711 27.4497H36.4917C36.3789 27.4497 36.2836 27.5452 36.2836 27.6583V40.232C36.2836 40.5526 36.024 40.8126 35.7039 40.8126H33.5793L38.6014 46.7372L43.6234 40.8127Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\",\"global_text_color\":\"#74787C\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"d2d9b5d6-522e-4a6f-a946-517ade75bd7e\"},{\"id\":\"8c2feaf7-30a9-4cee-afde-da0af55c4a7d\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Eco Friendly\",\"heading_selector\":\"h5\",\"title_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"\",\"size\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_text_color\":\"#74787C\",\"global_link_color\":\"#1F1F25\",\"global_link_hover_color\":\"var(--maincolor)\"},\"parent\":\"d2d9b5d6-522e-4a6f-a946-517ade75bd7e\"},{\"id\":\"20a50def-7d0e-44f1-b1c5-d5977c0c8b36\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Litarrices sociosqu in commodo quam proin facilisis<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"global_text_color\":\"#74787C\",\"title\":\"\",\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"d2d9b5d6-522e-4a6f-a946-517ade75bd7e\"}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"4ed9a0a7-9927-4f6f-91f2-727fe2995575\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"}},\"addons\":[{\"id\":\"08a44849-05b4-47be-93b8-86840485a6db\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/26.png\",\"alt\":\"\",\"height\":240,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.04)\",\"ho\":0,\"vo\":\"10\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-service-solari\",\"global_custom_css\":\".single-service-solari::before {\\n\\tposition: absolute;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\tbackground: #1b1b1b86;\\n\\tcontent: \\\"\\\";\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tborder-radius: 10px;\\n\\tz-index: -1;\\n}\\n\\n.single-service-solari::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tbackground: #fff;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\ttransition: 0.3s;\\n\\tz-index: -1;\\n\\tborder-radius: 10px;\\n}\\n\\n.single-service-solari .icon-area svg path {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .disc {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-service-solari:hover .icon-area svg path {\\n\\tfill: #fff;\\n}\\n\\n.single-service-solari:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-service-solari .title .sppb-addon-title:hover {\\ncolor: var(--maincolor);\\n}\\n\\n.single-service-solari:hover .disc {\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Single Service\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_text_color\":\"#74787C\",\"global_addon_z_index\":\"2\"},\"children\":[\"121bfe60-3235-4274-a59d-8ca717b7640d\",\"30d07506-cc1d-4d50-896c-df5dff684e98\",\"325416be-6936-42f2-b73d-5f7b12104eaa\"],\"parent\":false},{\"id\":\"121bfe60-3235-4274-a59d-8ca717b7640d\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 26px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"60\\\" height=\\\"60\\\" viewBox=\\\"0 0 60 60\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<circle cx=\\\"30\\\" cy=\\\"30\\\" r=\\\"29.5\\\" stroke=\\\"#E9E9E9\\\"><\\/circle>\\n<path d=\\\"M48 33.8061V26.1939H43.851C43.5345 25.0425 43.0758 23.9377 42.483 22.8996L45.4192 19.9634L40.0366 14.5808L37.1004 17.517C36.0623 16.9243 34.9575 16.4655 33.8061 16.149V12H26.1939V16.149C25.0425 16.4655 23.9377 16.9243 22.8996 17.517L19.9634 14.5808L14.5808 19.9634L17.517 22.8997C17.3447 23.2016 17.1829 23.5107 17.0338 23.8226L17.9893 24.2793C18.1828 23.8745 18.3995 23.4747 18.6336 23.0911L18.8506 22.7355L16.0785 19.9633L19.9633 16.0785L22.7354 18.8506L23.0911 18.6336C24.2581 17.9216 25.5224 17.3965 26.8488 17.0732L27.2529 16.9746V13.0591H32.7469V16.9747L33.1511 17.0732C34.4775 17.3966 35.7417 17.9216 36.9088 18.6337L37.2644 18.8507L40.0365 16.0785L43.9214 19.9634L41.1493 22.7355L41.3663 23.0912C42.0783 24.2582 42.6033 25.5225 42.9267 26.8489L43.0253 27.253H46.9408V32.7471H43.0253L42.9267 33.1512C42.6033 34.4776 42.0783 35.7419 41.3663 36.9089L41.1493 37.2645L43.9214 40.0367L40.0365 43.9215L37.2644 41.1494L36.9088 41.3664C35.7417 42.0784 34.4775 42.6035 33.1511 42.9268L32.7469 43.0254V46.941H27.2529V43.0254L26.8488 42.9268C25.5224 42.6035 24.2581 42.0784 23.0911 41.3664L22.7354 41.1494L19.9633 43.9215L16.0785 40.0367L18.8506 37.2645L18.6336 36.9089C17.9215 35.7419 17.3965 34.4776 17.0731 33.1512L16.9746 32.7471H13.0591V27.253H16.9747L17.0732 26.8489C17.2085 26.2941 17.3815 25.7428 17.5874 25.2105L16.5997 24.8283C16.4273 25.2739 16.2763 25.7316 16.1491 26.1939H12V33.8061H16.149C16.4655 34.9575 16.9242 36.0623 17.517 37.1004L14.5808 40.0366L19.9634 45.4192L22.8996 42.483C23.9377 43.0758 25.0425 43.5345 26.1939 43.851V48H33.8061V43.851C34.9575 43.5345 36.0623 43.0758 37.1004 42.483L40.0366 45.4192L45.4192 40.0366L42.483 37.1004C43.0758 36.0623 43.5345 34.9575 43.851 33.8061H48V33.8061Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<path d=\\\"M23.4163 36.5218L24.1687 35.7764C22.636 34.2293 21.792 32.1779 21.792 30C21.792 25.4741 25.4741 21.792 30 21.792C34.5259 21.792 38.2079 25.4741 38.2079 30C38.2079 34.5259 34.5259 38.208 30 38.208C28.1341 38.208 26.3759 37.5979 24.9154 36.4439L24.2588 37.2749C25.9082 38.5782 27.8934 39.2671 30 39.2671C35.1098 39.2671 39.267 35.1099 39.267 30C39.267 24.8901 35.1099 20.733 30 20.733C24.8902 20.733 20.733 24.8902 20.733 30.0001C20.733 32.4589 21.686 34.7751 23.4163 36.5218Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<path d=\\\"M27.5896 29.3727L26.731 29.9928L28.9907 33.1213L33.2444 28.0798L32.4349 27.3968L29.0555 31.4022L27.5896 29.3727Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<path d=\\\"M36.2148 31.3311C36.3075 30.8962 36.3545 30.4483 36.3545 30C36.3545 26.4961 33.5039 23.6455 30 23.6455C26.4962 23.6455 23.6455 26.4961 23.6455 30C23.6455 33.5039 26.4962 36.3545 30 36.3545C32.5788 36.3545 34.8835 34.8154 35.8717 32.4336L34.8936 32.0278C34.07 34.0128 32.1491 35.2954 30 35.2954C27.0801 35.2954 24.7046 32.9199 24.7046 30C24.7046 27.0801 27.0801 24.7046 30 24.7046C32.9199 24.7046 35.2954 27.0801 35.2954 30C35.2954 30.3743 35.2563 30.7478 35.179 31.1103L36.2148 31.3311Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<path d=\\\"M25.664 19.4726C25.3235 19.6134 24.9856 19.7728 24.6598 19.9465L25.158 20.8811C25.4535 20.7235 25.7599 20.5789 26.0686 20.4514L25.664 19.4726Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<path d=\\\"M27.7879 18.8306C27.4258 18.9022 27.0632 18.9926 26.7101 19.0993L27.0167 20.1131C27.3367 20.0163 27.6653 19.9344 27.9934 19.8695L27.7879 18.8306Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<path d=\\\"M24.2936 21.3978L23.7068 20.5162C23.4 20.7204 23.0995 20.9422 22.8137 21.1753L23.4832 21.9959C23.7425 21.7844 24.0152 21.5831 24.2936 21.3978Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\",\"global_text_color\":\"#74787C\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"08a44849-05b4-47be-93b8-86840485a6db\"},{\"id\":\"30d07506-cc1d-4d50-896c-df5dff684e98\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Easy Installation\",\"heading_selector\":\"h5\",\"title_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"\",\"size\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_text_color\":\"#74787C\",\"global_link_color\":\"#1F1F25\",\"global_link_hover_color\":\"var(--maincolor)\"},\"parent\":\"08a44849-05b4-47be-93b8-86840485a6db\"},{\"id\":\"325416be-6936-42f2-b73d-5f7b12104eaa\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Litarrices sociosqu in commodo quam proin facilisis<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"global_text_color\":\"#74787C\",\"title\":\"\",\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"08a44849-05b4-47be-93b8-86840485a6db\"}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"d39e6fc1-e24e-42d9-804a-ff02047bf427\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"}},\"addons\":[{\"id\":\"6c295766-9131-4778-ac73-bcdc9e764a53\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/27.png\",\"alt\":\"\",\"height\":240,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.04)\",\"ho\":0,\"vo\":\"10\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-service-solari\",\"global_custom_css\":\".single-service-solari::before {\\n\\tposition: absolute;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\tbackground: #1b1b1b86;\\n\\tcontent: \\\"\\\";\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tborder-radius: 10px;\\n\\tz-index: -1;\\n}\\n\\n.single-service-solari::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tbackground: #fff;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\ttransition: 0.3s;\\n\\tz-index: -1;\\n\\tborder-radius: 10px;\\n}\\n\\n.single-service-solari .icon-area svg path {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .disc {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-service-solari:hover .icon-area svg path {\\n\\tfill: #fff;\\n}\\n\\n.single-service-solari:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-service-solari .title .sppb-addon-title:hover {\\ncolor: var(--maincolor);\\n}\\n\\n.single-service-solari:hover .disc {\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Single Service\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_text_color\":\"#74787C\",\"global_addon_z_index\":\"2\"},\"children\":[\"ac6ab79b-fc8d-4ea4-acb7-a8deef4abb23\",\"06030e9c-762c-4a2b-9e9e-86d7fab19f9a\",\"2fdcacd4-24c3-4fa8-b02a-41439c6e3bf3\"],\"parent\":false},{\"id\":\"ac6ab79b-fc8d-4ea4-acb7-a8deef4abb23\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 26px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"60\\\" height=\\\"60\\\" viewBox=\\\"0 0 60 60\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<circle cx=\\\"30\\\" cy=\\\"30\\\" r=\\\"29.5\\\" stroke=\\\"#E9E9E9\\\"><\\/circle>\\n<path d=\\\"M46.1647 39.7097L42.3465 35.9398C42.486 35.7982 42.6212 35.6584 42.7474 35.5258C42.893 35.3734 43.0337 35.2264 43.1689 35.0902C43.5013 34.825 45.3513 33.2728 45.4168 31.5999C45.4429 30.9315 45.1779 30.3219 44.6495 29.8371C44.2723 29.4909 43.838 29.2935 43.3673 29.2419C43.3727 29.1873 43.3818 29.1327 43.3837 29.0775C43.4073 28.4151 43.1441 27.8127 42.623 27.3345C42.1499 26.9001 41.5688 26.6937 40.935 26.7393C40.7961 26.7489 40.659 26.7741 40.5225 26.8059C40.6014 26.5605 40.6554 26.3115 40.6663 26.0625C40.6924 25.4714 40.4922 24.9338 40.0864 24.5096C39.3325 23.7206 38.5609 23.6276 38.0472 23.6906C37.7469 23.7266 37.4606 23.8244 37.1895 23.9582C37.1925 23.8052 37.1853 23.654 37.1574 23.5058C37.053 22.9562 36.7304 22.5116 36.2227 22.2188C34.3545 21.1436 32.4863 23.0084 31.6031 24.383C31.2629 24.3344 30.9286 24.3176 30.6023 24.332L28.89 22.64C30.0819 19.7996 29.4226 16.4851 27.1862 14.2675C24.6926 11.802 20.8337 11.2878 17.804 13.017C17.6402 13.1101 17.5304 13.2733 17.5056 13.4581C17.4807 13.6435 17.545 13.8295 17.6778 13.9615L21.8982 18.1333L19.6649 20.3414L15.6234 16.3459C15.4815 16.2055 15.2795 16.1425 15.0824 16.1809C14.8852 16.2169 14.7196 16.3477 14.639 16.5295C13.3682 19.3939 14.0312 22.8134 16.2864 25.0364C18.5264 27.2511 21.88 27.9069 24.7557 26.7279L25.8184 27.7785C25.0026 29.6493 25.355 31.5789 25.557 32.3536L23.653 34.4692L23.1969 33.9892C23.0822 33.8686 22.9221 33.8002 22.7547 33.8002C22.7547 33.8002 22.7547 33.8002 22.7541 33.8002C22.5867 33.8002 22.4265 33.8686 22.3119 33.9898L19.486 36.9736C19.2688 37.2034 19.2676 37.5604 19.4835 37.7908L28.8427 47.8074C28.9549 47.9274 29.112 47.997 29.2776 48H29.2879C29.4499 48 29.6045 47.9364 29.7186 47.8224L32.7034 44.8415C32.9333 44.6117 32.9382 44.2439 32.7143 44.0081L32.4638 43.7447C32.8963 43.1117 33.9238 41.8835 35.2273 42.1907C36.4131 42.4661 37.6462 41.8865 38.7465 40.5551L42.0274 43.7969C42.5824 44.3489 43.3127 44.6255 44.043 44.6255C44.7636 44.6255 45.4842 44.3561 46.0343 43.8155L46.1823 43.6691C46.7137 43.1441 47.0042 42.4415 47 41.6909C46.9969 40.9421 46.6997 40.2389 46.1647 39.7097ZM43.8246 30.7179C44.0964 30.9669 44.2171 31.2315 44.2043 31.5525C44.1661 32.5588 42.8778 33.7864 42.3847 34.1746C42.3659 34.189 42.3477 34.2058 42.3313 34.222C42.1821 34.3708 42.0268 34.5334 41.8661 34.702C40.4352 36.199 39.6182 36.805 38.8454 36.1882C38.2746 35.734 38.4372 35.1496 38.5991 34.8214C39.4192 34.399 40.1598 33.625 40.7451 33.0058C40.8889 32.8534 41.0284 32.7058 41.1625 32.5696C41.3984 32.3782 42.4035 31.5225 42.9779 30.4407C43.3018 30.4035 43.5772 30.4905 43.8246 30.7179ZM41.0236 27.9363C41.3208 27.9189 41.5682 28.0041 41.7981 28.2153C42.0638 28.4583 42.1821 28.7193 42.1712 29.0349C42.1366 30.0363 40.8604 31.2687 40.3721 31.6587C40.3539 31.6731 40.3357 31.6893 40.3193 31.7061C40.172 31.8549 40.0179 32.0181 39.859 32.1868C38.4457 33.6838 37.6396 34.2916 36.882 33.6916C36.1741 33.1312 36.6121 32.3626 36.7049 32.2179C36.7322 32.1771 36.7419 32.1315 36.7576 32.0871C37.7124 32.0727 38.2176 31.6365 38.416 31.4061C38.8739 30.8757 38.9673 30.1407 38.7332 29.4321C38.8782 29.2899 39.0583 29.1033 39.2518 28.8825C39.768 28.4307 40.4316 27.9777 41.0236 27.9363ZM38.1952 24.8822C38.5433 24.8396 38.8757 24.9884 39.2063 25.334C39.3883 25.5242 39.4671 25.739 39.4556 26.0085C39.4271 26.6583 38.897 27.4383 38.3862 28.0341C38.268 28.1403 38.1582 28.2435 38.0611 28.3395C38.0423 28.3197 38.0278 28.2981 38.0084 28.2783C37.3691 27.6435 36.751 27.0951 36.1487 26.6151C36.2281 26.4999 36.3161 26.3661 36.4065 26.2161C36.8723 25.6244 37.5413 24.959 38.1952 24.8822ZM35.6137 23.2568C35.8181 23.3744 35.9267 23.5196 35.9661 23.726C36.0589 24.2138 35.7556 24.9332 35.4002 25.5368C35.3056 25.6598 35.22 25.7762 35.1478 25.8813C34.3605 25.3508 33.6023 24.9584 32.8672 24.701C33.4192 23.9726 34.5995 22.6706 35.6137 23.2568ZM25.3186 25.5872C25.136 25.406 24.8582 25.3592 24.6265 25.4714C22.1318 26.6607 19.1251 26.1459 17.144 24.1868C15.4596 22.526 14.827 20.0786 15.4439 17.8645L19.2367 21.6134C19.4738 21.848 19.8572 21.848 20.0943 21.6134L23.186 18.5569C23.3 18.4441 23.3637 18.2923 23.3637 18.1327C23.3637 17.9731 23.3 17.8207 23.186 17.7085L19.1323 13.7017C21.5561 12.6924 24.4167 13.2259 26.3279 15.1147C28.3041 17.0743 28.8239 20.0468 27.6211 22.511C27.5089 22.7408 27.5562 23.0162 27.7388 23.1962L29.1672 24.608C28.3708 24.8942 27.6253 25.3934 26.9369 26.1063C26.7513 26.2983 26.5918 26.4975 26.4438 26.6991L25.3186 25.5872ZM29.3043 46.5324L20.7585 37.3864L22.7559 35.2768L31.4303 44.4083L29.3043 46.5324ZM35.5069 41.0225C33.6448 40.5899 32.2819 41.9681 31.6195 42.8549L24.4876 35.347L26.6864 32.9038C26.8314 32.7424 26.8775 32.515 26.8071 32.3104C26.7962 32.2786 25.7335 29.0889 27.814 26.9355C28.9258 25.7846 30.1498 25.3436 31.5595 25.5842C33.1814 25.8621 35.0623 27.0537 37.1483 29.1255C37.7014 29.6739 37.7579 30.3195 37.4928 30.6267C37.0397 31.1529 35.5269 30.9855 33.2748 29.3769C32.4881 28.8141 31.8718 28.9125 31.494 29.0931C30.1128 29.7537 29.9133 32.605 29.8872 33.169C29.872 33.5002 30.1304 33.781 30.4652 33.796C30.7903 33.796 31.0833 33.5554 31.0991 33.2242C31.1021 33.1552 31.11 33.0838 31.1149 33.0136L37.8846 39.7031C37.3175 40.4171 36.4392 41.2373 35.5069 41.0225ZM45.3253 42.8213L45.1791 42.9659C44.5476 43.5851 43.5207 43.5785 42.8875 42.9491L31.3447 31.5435C31.514 30.8571 31.7523 30.3027 32.0229 30.1737C32.1691 30.1077 32.3995 30.2313 32.5657 30.3495C33.7516 31.1973 34.7202 31.6647 35.5081 31.8963C35.1879 32.6074 35.0387 33.7696 36.125 34.6282C36.5077 34.9306 36.8874 35.0758 37.2599 35.116C37.1677 35.7952 37.3521 36.538 38.0854 37.1218C38.5476 37.4902 39.0068 37.6408 39.4532 37.6408C40.1671 37.6408 40.8464 37.2514 41.4572 36.7564L45.3077 40.5575C45.6152 40.8617 45.7862 41.2667 45.7887 41.6963C45.7905 42.1247 45.6261 42.5237 45.3253 42.8213Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\",\"global_text_color\":\"#74787C\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"6c295766-9131-4778-ac73-bcdc9e764a53\"},{\"id\":\"06030e9c-762c-4a2b-9e9e-86d7fab19f9a\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Low Maintenance\",\"heading_selector\":\"h5\",\"title_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"\",\"size\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_text_color\":\"#74787C\",\"global_link_color\":\"#1F1F25\",\"global_link_hover_color\":\"var(--maincolor)\"},\"parent\":\"6c295766-9131-4778-ac73-bcdc9e764a53\"},{\"id\":\"2fdcacd4-24c3-4fa8-b02a-41439c6e3bf3\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Litarrices sociosqu in commodo quam proin facilisis<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"global_text_color\":\"#74787C\",\"title\":\"\",\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"6c295766-9131-4778-ac73-bcdc9e764a53\"}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"e42749d2-9dc1-48c0-a83c-8a61e68da308\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"}},\"addons\":[{\"id\":\"a957ed64-4ae7-4731-a8ce-820ddc0a26bf\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/28.png\",\"alt\":\"\",\"height\":240,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.04)\",\"ho\":0,\"vo\":\"10\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-service-solari\",\"global_custom_css\":\".single-service-solari::before {\\n\\tposition: absolute;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\tbackground: #1b1b1b86;\\n\\tcontent: \\\"\\\";\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tborder-radius: 10px;\\n\\tz-index: -1;\\n}\\n\\n.single-service-solari::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tbackground: #fff;\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\ttransition: 0.3s;\\n\\tz-index: -1;\\n\\tborder-radius: 10px;\\n}\\n\\n.single-service-solari .icon-area svg path {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari .disc {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-service-solari:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-service-solari:hover .icon-area svg path {\\n\\tfill: #fff;\\n}\\n\\n.single-service-solari:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-service-solari .title .sppb-addon-title:hover {\\ncolor: var(--maincolor);\\n}\\n\\n.single-service-solari:hover .disc {\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Single Service\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_text_color\":\"#74787C\",\"global_addon_z_index\":\"2\"},\"children\":[\"09e4046d-29cc-4a02-ac22-1a343b26b938\",\"613ec612-041b-4ce2-bb30-45a4ec7de556\",\"37642916-3ca7-4507-8368-fc0e8a0d1c3d\"],\"parent\":false},{\"id\":\"09e4046d-29cc-4a02-ac22-1a343b26b938\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 26px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"60\\\" height=\\\"60\\\" viewBox=\\\"0 0 60 60\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<circle cx=\\\"30\\\" cy=\\\"30\\\" r=\\\"29.5\\\" stroke=\\\"#E9E9E9\\\"><\\/circle>\\n<path d=\\\"M30.7778 37.6112C30.8644 38.3254 30.6734 38.9772 30.2253 39.4961C29.6954 40.1099 28.8123 40.5206 27.8079 40.6337V41.4041C27.8079 41.7247 27.5483 41.9847 27.2282 41.9847C26.9081 41.9847 26.6485 41.7247 26.6485 41.4041V40.6254C25.1636 40.4254 24.0087 39.4877 23.6751 38.1475C23.5977 37.8364 23.7867 37.5212 24.0973 37.4437C24.4082 37.3665 24.7226 37.5555 24.8001 37.8666C25.0984 39.065 26.2674 39.494 27.2251 39.5036C27.2302 39.5036 27.2354 39.5037 27.2404 39.5038C27.2726 39.5036 27.3045 39.5036 27.3361 39.5028C28.1738 39.4829 28.9637 39.182 29.3484 38.7364C29.5832 38.4645 29.6743 38.1422 29.6269 37.7511C29.515 36.8282 28.7489 36.2988 27.1428 36.0347C24.6082 35.6179 24.0181 34.3323 23.9695 33.3272C23.902 31.9343 24.876 30.7668 26.3933 30.4221C26.4768 30.4031 26.5621 30.3869 26.6485 30.3736V29.5866C26.6485 29.2659 26.9081 29.0059 27.2282 29.0059C27.5483 29.0059 27.8079 29.2659 27.8079 29.5866V30.3686C28.8959 30.5264 29.9711 31.155 30.5071 32.4341C30.6311 32.7297 30.4923 33.0701 30.1971 33.1942C29.9019 33.3184 29.5621 33.1793 29.4382 32.8836C29.0218 31.8903 28.1308 31.487 27.271 31.4856C27.2473 31.4874 27.2228 31.4875 27.1988 31.4865C27.0118 31.491 26.8271 31.5144 26.6497 31.5547C25.8821 31.729 25.0791 32.2715 25.1275 33.2709C25.1427 33.584 25.1888 34.5366 27.3306 34.8888C28.1172 35.0182 30.5112 35.4118 30.7778 37.6112ZM44.767 41.2577L39.3435 47.6559C39.1554 47.8778 38.8919 47.9999 38.6013 47.9999C38.3108 47.9999 38.0472 47.8777 37.8592 47.656L35.6892 45.096C33.4534 46.9768 30.5715 48 27.4874 48C27.412 48 27.3367 47.9993 27.261 47.9982C27.1873 47.9994 27.1128 47.9999 27.0392 47.9999C22.5695 48.0001 18.5101 45.8121 16.404 42.2523C14.4928 39.0221 14.5346 35.1681 16.5186 31.6788C17.7604 29.4948 19.6623 27.0218 22.4681 23.9474C21.6712 23.5843 21.1154 22.7798 21.1154 21.8472C21.1154 20.5941 22.1187 19.5718 23.363 19.5424L21.5303 17.7068C20.614 16.7889 20.614 15.2955 21.5303 14.3777C22.3059 13.6008 23.5392 13.4682 24.4629 14.062C24.5621 14.1257 24.6592 14.1345 24.7682 14.0893C24.877 14.0442 24.9395 13.9693 24.9646 13.8539C25.1987 12.7798 26.1644 12.0001 27.2609 12C28.3575 12 29.3233 12.7796 29.5575 13.8537C29.5827 13.9693 29.6451 14.0442 29.7541 14.0894C29.8629 14.1345 29.9599 14.1257 30.0592 14.062C30.9829 13.4682 32.2161 13.6008 32.9917 14.3777C33.9081 15.2956 33.9081 16.7891 32.9918 17.7069L31.1592 19.5424C32.4034 19.572 33.4067 20.5942 33.4067 21.8474C33.4067 22.7799 32.8509 23.5844 32.054 23.9474C33.2361 25.2428 34.2544 26.4285 35.1307 27.5298C35.1958 26.8346 35.7811 26.2886 36.4917 26.2886H40.711C41.4651 26.2887 42.0786 26.9032 42.0785 27.6585V39.6516H44.0249C44.4088 39.6516 44.7474 39.8684 44.9084 40.2173C45.0695 40.5659 45.0154 40.9646 44.767 41.2577ZM22.3501 16.8856L25.0012 19.5409H29.5211L32.172 16.8856C32.6363 16.4205 32.6363 15.6639 32.172 15.1988C31.7791 14.8052 31.1539 14.7381 30.6855 15.0392C30.2688 15.3071 29.7675 15.3519 29.3104 15.1621C28.8531 14.9724 28.5304 14.5858 28.4248 14.1014C28.3061 13.5567 27.8166 13.1613 27.261 13.1613C26.7055 13.1614 26.2161 13.5568 26.0974 14.1014C25.9918 14.5858 25.669 14.9725 25.2117 15.1622C24.7544 15.3518 24.2532 15.307 23.8367 15.0393C23.3682 14.7381 22.743 14.8052 22.35 15.1988C21.8857 15.6639 21.8857 16.4206 22.3501 16.8856ZM22.2748 21.8472C22.2748 22.4786 22.7876 22.9923 23.4179 22.9923H31.1041C31.7344 22.9923 32.2472 22.4786 32.2472 21.8473C32.2472 21.2159 31.7344 20.7023 31.1041 20.7023H23.4179C22.7876 20.7022 22.2748 21.2159 22.2748 21.8472ZM34.9389 44.2109L32.4357 41.2578C32.1872 40.9645 32.1332 40.5657 32.2943 40.2169C32.4554 39.8681 32.794 39.6513 33.1779 39.6513H35.1242V29.4233C33.9731 27.872 32.5117 26.1443 30.6669 24.1536H23.8548C20.8147 27.4342 18.8003 30.0124 17.526 32.2536C15.7277 35.4161 15.6835 38.7569 17.4012 41.6603C19.3318 44.9234 23.1071 46.9064 27.2512 46.837C27.2577 46.8368 27.2642 46.8368 27.2707 46.837C30.1609 46.8865 32.861 45.9568 34.9389 44.2109ZM38.4601 46.9038C38.4599 46.904 38.4598 46.9042 38.4597 46.9043L38.4601 46.9038ZM43.6234 40.8127H41.4988C41.1787 40.8127 40.9191 40.5527 40.9191 40.2321V27.6583C40.9191 27.5452 40.8239 27.4497 40.711 27.4497H36.4917C36.3789 27.4497 36.2836 27.5452 36.2836 27.6583V40.232C36.2836 40.5526 36.024 40.8126 35.7039 40.8126H33.5793L38.6014 46.7372L43.6234 40.8127Z\\\" fill=\\\"#1F1F25\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\",\"global_text_color\":\"#74787C\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"a957ed64-4ae7-4731-a8ce-820ddc0a26bf\"},{\"id\":\"613ec612-041b-4ce2-bb30-45a4ec7de556\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Affordable Price\",\"heading_selector\":\"h5\",\"title_text_shadow\":{\"enabled\":false,\"color\":\"transparent\",\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"inset\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 15px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"\",\"size\":{\"xl\":{\"value\":\"20\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_text_color\":\"#74787C\",\"global_link_color\":\"#1F1F25\",\"global_link_hover_color\":\"var(--maincolor)\"},\"parent\":\"a957ed64-4ae7-4731-a8ce-820ddc0a26bf\"},{\"id\":\"37642916-3ca7-4507-8368-fc0e8a0d1c3d\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Litarrices sociosqu in commodo quam proin facilisis<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"global_text_color\":\"#74787C\",\"title\":\"\",\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"a957ed64-4ae7-4731-a8ce-820ddc0a26bf\"}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":false},{\"id\":\"f84b4789-56be-41f9-8982-39648c8e72e7\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":1,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"about\",\"class\":\"\"},\"layout\":\"6+6\",\"columns\":[{\"id\":\"265a01b1-0ef5-450b-af42-55ea051c1871\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"}},\"addons\":[{\"id\":\"9b69122e-829a-4579-b947-9a1f4e6e232e\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 10% -50px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"stok-bg\",\"global_custom_css\":\".stok-bg .sppb-addon-title {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":1,\"hidden_sm\":1,\"hidden_xs\":1,\"acl\":\"\",\"admin_label\":\"Background Moving Text\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"About Us\",\"heading_selector\":\"div\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"100\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_addon_z_index\":\"-1\",\"instFormId\":\"9b69122e-829a-4579-b947-9a1f4e6e232e\"},\"parent\":false},{\"id\":\"24372ee8-9db8-46a4-8306-dc8bf9aeb971\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Section Title Container\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"7b073c30-0538-491d-8ba3-dc61ac953f0b\",\"6062b778-87ec-4c38-8b87-3f9e79516da3\"]},{\"id\":\"c4476ca2-42dc-4f3e-96c4-adfdb611de5f\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"flex\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"column\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"flex-start\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"flex-start\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"70px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"30px\"},\"overflow\":\"visible\"},\"children\":[\"0df56b25-de23-4872-8815-91d68ba732ca\",\"ca714962-a87b-4ced-a427-797b9c7de63c\"]},{\"id\":\"6cd435b8-7157-42f9-90a5-32a425e11e6c\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"40px 0px 0px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"flex\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"column\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"flex-start\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"flex-start\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"60px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"30px\"},\"overflow\":\"visible\"},\"children\":[\"15f8a358-1466-437c-9687-2e8d7577cca9\",\"774fc0fc-a95d-42e1-a570-06750d659751\"]},{\"id\":\"b37caf53-1d4d-4c44-8b57-8df7fadeb4a2\",\"type\":\"content\",\"name\":\"empty_space\",\"visibility\":true,\"title\":\"Empty Space\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.5 13.6h-4.9c-.3 0-.5-.4-.3-.7l2.5-2.5c.2-.2.4-.2.5 0l2.5 2.5c.2.2 0 .7-.3.7zM13.5 18.3h4.9c.3 0 .5.4.3.7l-2.5 2.5c-.2.2-.4.2-.5 0L13.2 19c-.2-.3 0-.7.3-.7z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 22.9H2.7c-.9 0-1.7.8-1.7 1.7v5.7c0 .9.8 1.7 1.7 1.7.9 0 1.7-.8 1.7-1.7v-4h22.9v4c0 .9.8 1.7 1.7 1.7.9 0 1.7-.8 1.7-1.7v-5.7c0-1-.8-1.7-1.7-1.7zM29 0c-.9 0-1.7.8-1.7 1.7v4H4.4v-4C4.4.8 3.7 0 2.7 0S1 .8 1 1.7v5.7c0 .9.8 1.7 1.7 1.7H29c.9 0 1.7-.8 1.7-1.7V1.7C30.7.8 29.9 0 29 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":1,\"hidden_lg\":1,\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"gap\":{\"xl\":40}}},{\"id\":\"15f8a358-1466-437c-9687-2e8d7577cca9\",\"type\":\"general\",\"name\":\"button\",\"visibility\":true,\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Learn More\",\"aria_label\":\"\",\"type\":\"primary\",\"appearance\":\"\",\"shape\":\"rounded\",\"button_padding\":\"\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"icon_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_style_state\":\"normal\",\"color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"background_color\":\"#3366FF\",\"background_color_hover\":\"#0037DD\",\"background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"button_link_style_state\":\"normal\",\"link_button_color\":\"#3366FF\",\"link_button_border_width\":1,\"link_border_color\":\"#3366FF\",\"link_button_hover_color\":\"#0037DD\",\"link_button_border_hover_color\":\"#0037DD\",\"url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=139\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"6cd435b8-7157-42f9-90a5-32a425e11e6c\"},{\"id\":\"774fc0fc-a95d-42e1-a570-06750d659751\",\"type\":\"content\",\"name\":\"feature\",\"visibility\":true,\"title\":\"Feature Box\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 26a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 31a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.458 0c.423 0 .81.24.996.62l2.63 5.327 5.882.86a1.111 1.111 0 01.614 1.895l-4.255 4.144 1.005 5.855a1.111 1.111 0 01-1.613 1.171l-5.259-2.765-5.26 2.765a1.111 1.111 0 01-1.611-1.17l1.004-5.856-4.255-4.144a1.111 1.111 0 01.614-1.895l5.882-.86L15.462.62c.187-.379.573-.619.996-.619zm0 3.621l-1.892 3.833a1.111 1.111 0 01-.836.608l-4.232.618 3.062 2.982c.262.255.382.623.32.984l-.723 4.211 3.784-1.99c.324-.17.71-.17 1.034 0l3.784 1.99-.723-4.21a1.11 1.11 0 01.32-.985l3.062-2.982-4.232-.618a1.111 1.111 0 01-.836-.608l-1.892-3.833z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"call-button\",\"global_custom_css\":\".call-button .sppb-addon-content {\\n\\tdisplay: flex;\\n\\talign-items: center;\\n\\tgap: 14px;\\n}\\n\\n.call-button .sppb-media-content {\\n\\tdisplay: flex;\\n\\tflex-direction: column-reverse;\\n}\\n\\n.call-button .sppb-icon-container {\\n\\theight: 55px;\\n\\twidth: 55px;\\n\\tdisplay: flex !important;\\n\\talign-items: center;\\n\\tjustify-content: center;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"+236-3256.21456\",\"heading_selector\":\"h6\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_position\":\"after\",\"feature_type\":\"icon\",\"icon_name\":\"fas fa-phone\",\"icon_size\":{\"xl\":\"16\"},\"icon_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.08)\",\"ho\":0,\"vo\":\"10\",\"blur\":\"21\",\"spread\":0,\"inset\":false},\"feature_image\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"feature_image_alt\":\"\",\"feature_image_width\":{\"xl\":50},\"text\":\"<p>Call Us 24\\/7<\\/p>\",\"url_appear\":\"title\",\"feature_style_state\":\"normal\",\"icon_color\":\"var(--maincolor)\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"btn_aria_label\":\"\",\"btn_type\":\"custom\",\"button_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_appearance\":\"\",\"btn_shape\":\"rounded\",\"link_btn_padding_bottom\":\"\",\"btn_size\":\"\",\"btn_block\":\"\",\"button_margin\":{\"xl\":\"25px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"btn_icon_position\":\"left\",\"btn_style_state\":\"normal\",\"btn_color\":\"#FFFFFF\",\"btn_color_hover\":\"#FFFFFF\",\"btn_background_color\":\"#3366FF\",\"btn_background_color_hover\":\"#0037DD\",\"btn_background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"link_btn_style_state\":\"normal\",\"link_btn_border_color\":\"\",\"link_btn_hover_color\":\"\",\"link_btn_border_hover_color\":\"\",\"title_url\":{\"type\":\"url\",\"url\":\"tel:+4733378901\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"btn_text\":\"\",\"btn_url\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"content_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"type\":\"google\"},\"btn_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"title_margin_top\":{\"xl\":\"6\"},\"title_margin_bottom\":{\"xl\":\"0\"},\"icon_border_radius\":{\"xl\":\"400\"},\"text_background\":\"\",\"addon_color\":\"#74787C\"},\"parent\":\"6cd435b8-7157-42f9-90a5-32a425e11e6c\"},{\"id\":\"0df56b25-de23-4872-8815-91d68ba732ca\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Animated Number Container\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"flex\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"flex-start\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"20px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"b8f6466c-f610-4d47-8243-a460c41c3f3b\",\"f65e8d49-d6a3-4010-af8d-607a7056c221\"],\"parent\":\"c4476ca2-42dc-4f3e-96c4-adfdb611de5f\"},{\"id\":\"ca714962-a87b-4ced-a427-797b9c7de63c\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Animated Number Container\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"flex\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"flex-start\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"20px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"89f9d3d4-cc54-404f-82c6-e12ad0671bc7\",\"2c894ba3-e097-44fa-80dc-e203453ac33b\"],\"parent\":\"c4476ca2-42dc-4f3e-96c4-adfdb611de5f\"},{\"id\":\"89f9d3d4-cc54-404f-82c6-e12ad0671bc7\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"51\\\" height=\\\"55\\\" viewBox=\\\"0 0 51 55\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<path d=\\\"M49.2801 29.5011C48.9182 29.1392 48.4886 28.852 48.0157 28.6561C47.5428 28.4602 47.0359 28.3594 46.5241 28.3594C46.0122 28.3594 45.5054 28.4602 45.0325 28.6561C44.5596 28.852 44.1299 29.1392 43.768 29.5011L37.0962 36.173C36.8035 35.6311 36.3702 35.1782 35.8418 34.8618C35.3135 34.5454 34.7096 34.3772 34.0938 34.375H24.3343C23.4942 33.3581 22.4508 32.528 21.2711 31.9379C20.0914 31.3478 18.8015 31.0106 17.4839 30.9481C16.1664 30.8856 14.8503 31.099 13.62 31.5747C12.3897 32.0505 11.2724 32.778 10.3397 33.7107L6.59378 37.4567L5.48261 36.3455C5.40283 36.2657 5.30811 36.2024 5.20385 36.1592C5.0996 36.116 4.98785 36.0938 4.875 36.0938C4.76215 36.0938 4.65041 36.116 4.54615 36.1592C4.4419 36.2024 4.34718 36.2657 4.2674 36.3455L0.829899 39.783C0.75008 39.8628 0.686761 39.9575 0.643561 40.0618C0.60036 40.1661 0.578125 40.2778 0.578125 40.3907C0.578125 40.5035 0.60036 40.6152 0.643561 40.7195C0.686761 40.8238 0.75008 40.9185 0.829899 40.9983L14.5799 54.7483C14.6597 54.8281 14.7544 54.8914 14.8587 54.9346C14.9629 54.9778 15.0747 55 15.1875 55C15.3004 55 15.4121 54.9778 15.5164 54.9346C15.6206 54.8914 15.7153 54.8281 15.7951 54.7483L19.2326 51.3108C19.3124 51.231 19.3757 51.1363 19.4189 51.032C19.4621 50.9277 19.4844 50.816 19.4844 50.7032C19.4844 50.5903 19.4621 50.4786 19.4189 50.3743C19.3757 50.27 19.3124 50.1753 19.2326 50.0955L18.1215 48.9844L19.0853 48.0205C19.57 47.5389 20.2249 47.2677 20.9082 47.2656H33.4682C34.5972 47.2688 35.7157 47.0479 36.7588 46.6158C37.8019 46.1837 38.7489 45.549 39.545 44.7483L49.2801 35.0132C49.6421 34.6513 49.9293 34.2217 50.1252 33.7488C50.3211 33.2759 50.4219 32.7691 50.4219 32.2572C50.4219 31.7453 50.3211 31.2385 50.1252 30.7656C49.9293 30.2927 49.6421 29.863 49.2801 29.5011ZM15.1875 52.9254L2.65274 40.3906L4.87503 38.1683L17.4098 50.7031L15.1875 52.9254ZM48.0649 33.798L38.3298 43.5331C37.6928 44.1736 36.9352 44.6813 36.1007 45.027C35.2662 45.3726 34.3714 45.5493 33.4682 45.5469H20.9082C20.3437 45.5453 19.7846 45.6558 19.2631 45.8718C18.7416 46.0878 18.2682 46.4051 17.8701 46.8053L16.9063 47.7692L7.80899 38.6719L11.5549 34.926C12.3283 34.1527 13.2566 33.5518 14.2788 33.1629C15.3009 32.7739 16.3938 32.6058 17.4856 32.6694C18.5774 32.733 19.6434 33.027 20.6135 33.532C21.5836 34.037 22.4358 34.7416 23.1141 35.5994L23.2463 35.7669C23.3267 35.8688 23.4291 35.9511 23.5459 36.0077C23.6627 36.0644 23.7908 36.0938 23.9206 36.0938H34.0938C34.5496 36.0938 34.9868 36.2748 35.3091 36.5972C35.6314 36.9195 35.8125 37.3567 35.8125 37.8125C35.8125 38.2683 35.6314 38.7055 35.3091 39.0278C34.9868 39.3502 34.5496 39.5312 34.0938 39.5312H22.0625C21.8346 39.5312 21.616 39.6218 21.4549 39.783C21.2937 39.9441 21.2032 40.1627 21.2032 40.3906C21.2032 40.6185 21.2937 40.8371 21.4549 40.9983C21.616 41.1595 21.8346 41.25 22.0625 41.25H34.0938C34.9344 41.2474 35.7448 40.9361 36.3711 40.3754C36.9974 39.8147 37.396 39.0436 37.4913 38.2084L44.9833 30.7163C45.3984 30.32 45.9502 30.0989 46.5241 30.0989C47.098 30.0989 47.6499 30.32 48.0649 30.7163C48.2673 30.9187 48.4278 31.1589 48.5373 31.4233C48.6468 31.6876 48.7032 31.971 48.7032 32.2572C48.7032 32.5433 48.6468 32.8267 48.5373 33.091C48.4278 33.3554 48.2673 33.5957 48.0649 33.798Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M14.9675 17.512C14.9555 17.5288 14.9374 17.5383 14.9265 17.5562C14.9237 17.5609 14.9239 17.5663 14.9211 17.571C12.3074 20.8906 10.8877 24.9936 10.8906 29.2186C10.8906 29.3592 10.8915 29.4989 10.9011 29.6391C10.9162 29.856 11.013 30.0591 11.1719 30.2076C11.3308 30.356 11.5401 30.4386 11.7576 30.4389C11.7777 30.4389 11.7978 30.438 11.818 30.4368C11.9306 30.429 12.0405 30.3991 12.1415 30.3488C12.2426 30.2985 12.3327 30.2287 12.4068 30.1436C12.4808 30.0585 12.5374 29.9596 12.5733 29.8526C12.6091 29.7455 12.6235 29.6325 12.6157 29.5199C12.6085 29.4192 12.6094 29.3189 12.6094 29.2186C12.6101 25.6065 13.7565 22.0877 15.8835 19.1683C18.3139 20.7552 19.7364 22.2883 19.7949 23.4304C19.705 24.5169 19.3619 25.5671 18.7929 26.497C18.5398 27.0194 18.2742 27.5691 18.0292 28.1579C17.9858 28.2621 17.9634 28.3738 17.9632 28.4866C17.963 28.5995 17.985 28.7113 18.0281 28.8157C18.1149 29.0264 18.282 29.194 18.4924 29.2816C18.5966 29.325 18.7084 29.3474 18.8212 29.3476C18.9341 29.3477 19.0459 29.3257 19.1502 29.2827C19.361 29.1958 19.5286 29.0288 19.6162 28.8183C19.8482 28.2611 20.1004 27.7407 20.34 27.246C21.0535 26.0634 21.4563 24.7195 21.5111 23.3394C21.4223 21.606 19.8828 19.7526 16.9648 17.8239C18.2806 16.3345 19.8434 15.0831 21.5845 14.1249C23.2583 17.3865 25.2723 19.108 27.4714 19.108C27.6314 19.108 27.7912 19.099 27.9502 19.0811C29.4737 18.9841 30.9279 18.4089 32.1056 17.4375C32.8622 16.8525 33.1756 16.6108 34.9103 17.2167C36.5305 17.7808 38.2384 17.0737 39.7857 15.2385C41.125 16.198 42.3196 17.3449 43.3327 18.6441C42.2982 19.7489 41.4842 21.041 40.9344 22.4511C40.2013 24.0515 39.7057 25.0372 38.7943 25.1228C38.2023 25.1596 37.6085 25.1571 37.0168 25.1152C34.7492 25.0036 31.929 24.8714 29.9144 28.8318C29.4576 29.7241 29.1507 30.6856 29.0059 31.6776C28.9743 31.9033 29.0337 32.1323 29.1709 32.3142C29.3082 32.4962 29.5121 32.6161 29.7377 32.6477C29.7776 32.6535 29.8179 32.6563 29.8581 32.6561C30.0652 32.6559 30.2652 32.5808 30.4213 32.4448C30.5775 32.3088 30.6792 32.121 30.7079 31.9159C30.8247 31.1111 31.0748 30.3313 31.4477 29.6085C32.9566 26.6418 34.7139 26.7286 36.935 26.8319C37.6066 26.8789 38.2807 26.8797 38.9525 26.8344C40.9016 26.6506 41.7127 24.8794 42.497 23.1665C42.9412 22.0427 43.5633 20.9978 44.3395 20.0717C45.4889 21.8905 46.2834 23.9105 46.681 26.0249C46.7016 26.1359 46.744 26.2418 46.8055 26.3365C46.8671 26.4311 46.9467 26.5127 47.0398 26.5766C47.1329 26.6404 47.2377 26.6853 47.3482 26.7087C47.4586 26.732 47.5726 26.7333 47.6836 26.7126C47.7946 26.6919 47.9004 26.6495 47.995 26.5878C48.0896 26.5262 48.1711 26.4465 48.2349 26.3533C48.2987 26.2602 48.3435 26.1553 48.3667 26.0448C48.39 25.9343 48.3912 25.8204 48.3704 25.7094C47.5792 21.5283 45.3995 17.7368 42.1844 14.9492C38.9693 12.1616 34.9073 10.5412 30.6563 10.3505V9.40098C30.6563 8.91969 30.7917 8.44811 31.047 8.04008C31.3022 7.63204 31.667 7.30399 32.0998 7.09335C32.5779 7.65046 33.1708 8.09766 33.8378 8.40434C34.5048 8.71101 35.2303 8.86992 35.9644 8.87017C36.6606 8.8642 37.3507 8.74019 38.0054 8.50342C39.1016 8.11974 40.1412 7.59049 41.0963 6.92989C41.5098 6.55875 42.0186 6.31011 42.5654 6.21183C43.1123 6.11355 43.6758 6.16953 44.1926 6.37348C44.3667 6.41813 44.5504 6.40709 44.7179 6.34191C44.8853 6.27674 45.0282 6.1607 45.1263 6.01013C45.2244 5.85956 45.2728 5.68203 45.2647 5.5025C45.2567 5.32298 45.1926 5.15049 45.0814 5.00931C44.8972 4.77513 40.5214 -0.706329 36.3093 0.0779364C32.2436 0.835768 31.7673 3.3018 31.5691 5.44038C30.864 5.73908 30.2521 6.22146 29.7969 6.83723C29.3418 6.22135 28.7297 5.73887 28.0246 5.44011C27.8263 3.30161 27.3501 0.835716 23.2844 0.0779364C19.0719 -0.710523 14.6966 4.77555 14.5123 5.00927C14.4012 5.15046 14.337 5.32294 14.329 5.50247C14.3209 5.682 14.3694 5.85953 14.4675 6.0101C14.5656 6.16067 14.7084 6.2767 14.8759 6.34188C15.0433 6.40705 15.227 6.41809 15.4011 6.37344C15.9179 6.16937 16.4814 6.11334 17.0283 6.21162C17.5752 6.3099 18.084 6.55861 18.4974 6.92985C19.4526 7.59046 20.4922 8.11971 21.5883 8.5034C22.243 8.74041 22.9331 8.86443 23.6294 8.87015C24.3635 8.86987 25.0889 8.71094 25.756 8.40425C26.423 8.09755 27.0159 7.65034 27.494 7.09323C27.9268 7.30389 28.2916 7.63197 28.5468 8.04003C28.8021 8.44808 28.9374 8.91967 28.9375 9.40098V10.3342C26.2297 10.4556 23.58 11.1597 21.1691 12.3984C18.7582 13.6371 16.6429 15.3813 14.9675 17.512ZM36.624 1.76731C38.5069 1.41358 40.7577 3.04882 42.2901 4.51286C41.5133 4.6743 40.783 5.00925 40.1539 5.49267C39.315 6.07617 38.4008 6.54326 37.4364 6.88118C36.8417 7.14066 36.1866 7.23015 35.5441 7.13969C34.9015 7.04923 34.2967 6.78237 33.7967 6.36878L36.068 5.41546C36.1724 5.372 36.2672 5.30836 36.3469 5.2282C36.4266 5.14804 36.4898 5.05294 36.5327 4.94834C36.5756 4.84374 36.5974 4.7317 36.597 4.61864C36.5965 4.50559 36.5737 4.39373 36.5299 4.28949C36.4861 4.18526 36.4222 4.09068 36.3418 4.01119C36.2614 3.9317 36.1661 3.86886 36.0614 3.82626C35.9567 3.78367 35.8446 3.76216 35.7315 3.76297C35.6185 3.76378 35.5067 3.78689 35.4026 3.83098L33.3899 4.67583C33.6288 3.20581 34.2323 2.21336 36.624 1.76731ZM22.1573 6.88118C21.1929 6.54326 20.2788 6.07617 19.4399 5.49267C18.8102 5.00852 18.0789 4.67339 17.3011 4.51247C18.831 3.04801 21.0751 1.41528 22.9697 1.76733C25.3615 2.21328 25.9649 3.20592 26.2038 4.6757L24.1912 3.83098C24.0872 3.78728 23.9756 3.76451 23.8627 3.76395C23.7499 3.76339 23.638 3.78506 23.5336 3.82773C23.4291 3.8704 23.3341 3.93322 23.2539 4.01262C23.1737 4.09201 23.1099 4.18643 23.0662 4.29046C23.0225 4.3945 22.9998 4.50613 22.9992 4.61897C22.9986 4.73181 23.0203 4.84366 23.063 4.94812C23.1056 5.05259 23.1685 5.14762 23.2479 5.22781C23.3273 5.30799 23.4217 5.37176 23.5257 5.41545L25.7975 6.36882C25.2973 6.78217 24.6923 7.04886 24.0498 7.1393C23.4072 7.22974 22.7522 7.1404 22.1573 6.88118ZM35.4768 15.5937C33.0447 14.7452 32.1463 15.2341 31.0544 16.0775C30.125 16.8538 28.9692 17.3082 27.76 17.3729C25.7239 17.6062 24.0851 15.2452 23.1213 13.381C25.5566 12.3543 28.1959 11.9031 30.834 12.0624C33.4721 12.2217 36.0379 12.9872 38.332 14.2995C37.5873 15.138 36.5368 15.964 35.4768 15.5937Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"ca714962-a87b-4ced-a427-797b9c7de63c\"},{\"id\":\"2c894ba3-e097-44fa-80dc-e203453ac33b\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"60\",\"duration\":\"10000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"Save World\",\"number_before_after_text\":\"%\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"color\":\"var(--maincolor)\",\"title_margin\":{\"xl\":\"5px 0px 0px 0px\"},\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":\"#1F1F25\"},\"parent\":\"ca714962-a87b-4ced-a427-797b9c7de63c\"},{\"id\":\"b8f6466c-f610-4d47-8243-a460c41c3f3b\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"55\\\" height=\\\"55\\\" viewBox=\\\"0 0 55 55\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<path d=\\\"M23.8916 52.4916H21.7666V50.9083C21.7666 50.2666 21.2416 49.7416 20.6 49.7416H19.4833V47.2999H28.525C28.9583 47.2999 29.3583 47.0833 29.5916 46.7166C29.825 46.35 29.8583 45.9 29.6833 45.5083L25.1 35.3249C24.9 34.8749 24.4416 34.575 23.9416 34.575H6.8833C6.3833 34.575 5.9333 34.8666 5.72497 35.3249L1.14164 45.5083C0.966637 45.9 0.99997 46.35 1.2333 46.7166C1.46664 47.0833 1.86664 47.2999 2.29997 47.2999H11.3416V49.7416H10.225C9.5833 49.7416 9.0583 50.2666 9.0583 50.9083V52.4916H6.94164C6.6083 52.4916 6.3333 52.7666 6.3333 53.1C6.3333 53.4333 6.6083 53.7083 6.94164 53.7083H23.8916C24.225 53.7083 24.5 53.4333 24.5 53.1C24.5 52.7666 24.2333 52.4916 23.8916 52.4916ZM28.5833 46.0083L28.5333 46.0833H23L22.4166 43.4916H27.4583L28.5833 46.0083ZM26.9083 42.2749H22.1416L21.5333 39.5916H25.7L26.9083 42.2749ZM23.95 35.7916C23.975 35.7916 23.9916 35.8083 24 35.825L25.15 38.3833H21.2583L20.675 35.7916H23.95ZM16.025 35.7916H19.4333L20.0166 38.3833H16.025V35.7916ZM16.025 39.5999H20.2916L20.9 42.2833H16.0333V39.5999H16.025ZM16.025 43.4916H21.1666L21.75 46.0833H16.0166V43.4916H16.025ZM18.275 47.2999V49.7416H12.5583V47.2999H18.275ZM11.4083 35.7916H14.8166V38.3833H10.825L11.4083 35.7916ZM14.8083 39.5999V42.2833H9.94164L10.55 39.5999H14.8083ZM6.8833 35.7916H10.1583L9.57497 38.3833H5.7083L6.8833 35.7916ZM7.84164 46.0833H2.29997L2.24997 46.0083L3.39164 43.4916H8.42497L7.84164 46.0833ZM3.94164 42.2749L5.1583 39.5916H9.29997L8.69164 42.2749H3.94164ZM9.0833 46.0833L9.66664 43.4916H14.8083V46.0833H9.0833ZM20.5583 52.4916H10.2666L10.2333 50.9499L20.5583 50.9083V52.4916Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M51.1667 24.3167C50.8334 23.4501 50.075 22.8417 49.1834 22.7167L40.6417 21.4334C40.65 21.3417 40.6667 21.2501 40.6667 21.1584C40.6667 19.3834 39.5834 17.8584 38.05 17.2084V2.33339C38.05 1.88339 37.7834 1.50006 37.3584 1.35839C36.9417 1.20839 36.5 1.34173 36.225 1.68339L31.7584 7.20006C31.1917 7.90839 31.0334 8.86673 31.3667 9.72506L34.3917 17.3917C33.0334 18.1167 32.0917 19.5251 32.0917 21.1667C32.0917 21.4917 32.1334 21.8001 32.2 22.1001L19.2834 29.5584C18.9 29.7751 18.7084 30.2001 18.7834 30.6334C18.8667 31.0667 19.2 31.3917 19.6334 31.4584L26.6417 32.5667C26.7667 32.5834 26.9 32.5917 27.025 32.5917C27.7917 32.5917 28.5334 32.2417 29.0167 31.6334L34.3584 24.9167C34.9667 25.2417 35.65 25.4501 36.3834 25.4501C37.3667 25.4501 38.2584 25.1084 38.9834 24.5501L52.2417 32.1917C52.4084 32.2834 52.5834 32.3334 52.7584 32.3334C53 32.3334 53.2334 32.2501 53.4334 32.0751C53.7667 31.7834 53.875 31.3417 53.7167 30.9417L51.1667 24.3167ZM32.4917 9.27506C32.325 8.83339 32.4 8.32506 32.7 7.95839L36.8334 2.85006V16.9167C36.6834 16.9001 36.5334 16.8667 36.3834 16.8667C36.0917 16.8667 35.8 16.9001 35.525 16.9501L32.4917 9.27506ZM28.0667 30.8834C27.7667 31.2584 27.3084 31.4417 26.8334 31.3667L20.35 30.3417L32.65 23.2334C32.85 23.5917 33.0834 23.9251 33.375 24.2084L28.0667 30.8834ZM36.3834 24.2334C34.6834 24.2334 33.3084 22.8501 33.3084 21.1584C33.3084 19.4584 34.6917 18.0834 36.3834 18.0834C38.075 18.0834 39.4584 19.4667 39.4584 21.1584C39.4584 22.8584 38.075 24.2334 36.3834 24.2334ZM39.8584 23.6501C40.0834 23.3417 40.2584 22.9917 40.3917 22.6251L49.0084 23.9167C49.4667 23.9751 49.8584 24.3001 50.025 24.7501L52.3834 30.8751L39.8584 23.6501Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M44.175 52.4917H42.5333L39 26.8334C38.9583 26.5001 38.65 26.2751 38.3166 26.3167C37.9833 26.3584 37.75 26.6667 37.8 27.0001L38.9 34.9751H36.9083C36.575 34.9751 36.3 35.2501 36.3 35.5834C36.3 35.9167 36.575 36.1917 36.9083 36.1917H39.0666L40.7 48.0501H37.0916C36.7583 48.0501 36.4833 48.3251 36.4833 48.6584C36.4833 48.9917 36.7583 49.2667 37.0916 49.2667H40.8666L41.3083 52.4917H31.5916L32.875 43.1501H36.3583C36.6916 43.1501 36.9666 42.8751 36.9666 42.5417C36.9666 42.2084 36.6916 41.9334 36.3583 41.9334H33.0416L35.0916 27.0501C35.1333 26.7167 34.9083 26.4084 34.575 26.3667C34.2333 26.3251 33.9333 26.5501 33.8916 26.8834L30.3666 52.4917H28.8083C28.475 52.4917 28.2 52.7667 28.2 53.1001C28.2 53.4334 28.475 53.7084 28.8083 53.7084H44.1666C44.5 53.7084 44.775 53.4334 44.775 53.1001C44.775 52.7667 44.5083 52.4917 44.175 52.4917Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M20.25 13.9418C20.5833 13.9418 20.8583 13.6668 20.8583 13.3334C20.8583 11.6668 22.2166 10.3084 23.8833 10.3084C25.55 10.3084 26.9 11.6668 26.9 13.3334C26.9 15.0001 25.55 16.3501 23.8833 16.3501H10.2416C9.9083 16.3501 9.6333 16.6251 9.6333 16.9584C9.6333 17.2918 9.9083 17.5668 10.2416 17.5668H23.8833C26.2166 17.5668 28.1166 15.6668 28.1166 13.3334C28.1166 11.0001 26.2166 9.1001 23.8833 9.1001C21.55 9.1001 19.65 11.0001 19.65 13.3334C19.6416 13.6751 19.9083 13.9418 20.25 13.9418Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M3.01654 11.9166H13.4165C15.7499 11.9166 17.6499 10.0166 17.6499 7.68329C17.6499 5.34995 15.7499 3.44995 13.4165 3.44995C11.0832 3.44995 9.1832 5.34995 9.1832 7.68329C9.1832 8.01662 9.4582 8.29162 9.79154 8.29162C10.1249 8.29162 10.3999 8.01662 10.3999 7.68329C10.3999 6.01662 11.7582 4.65828 13.4249 4.65828C15.0915 4.65828 16.4415 6.01662 16.4415 7.68329C16.4415 9.34995 15.0915 10.7 13.4249 10.7H3.01654C2.6832 10.7 2.4082 10.975 2.4082 11.3083C2.41654 11.6416 2.6832 11.9166 3.01654 11.9166Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M42.4001 11.9167H50.2167C52.2834 11.9167 53.9584 10.2417 53.9584 8.17505C53.9584 6.10838 52.2834 4.42505 50.2167 4.42505C48.1501 4.42505 46.4667 6.10838 46.4667 8.17505C46.4667 8.50838 46.7417 8.78338 47.0751 8.78338C47.4084 8.78338 47.6834 8.50838 47.6834 8.17505C47.6834 6.77505 48.8167 5.64172 50.2167 5.64172C51.6084 5.64172 52.7417 6.77505 52.7417 8.17505C52.7417 9.56672 51.6084 10.7 50.2167 10.7H42.4001C42.0667 10.7 41.7917 10.975 41.7917 11.3084C41.8001 11.6417 42.0667 11.9167 42.4001 11.9167Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M42.0082 16.3251H50.4166C50.7499 16.3251 51.0249 16.0501 51.0249 15.7167C51.0249 15.3834 50.7499 15.1084 50.4166 15.1084H42.0082C41.6749 15.1084 41.3999 15.3834 41.3999 15.7167C41.3999 16.0501 41.6666 16.3251 42.0082 16.3251Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M4.73333 20.55C4.4 20.55 4.125 20.825 4.125 21.1584C4.125 21.4917 4.4 21.7667 4.73333 21.7667H16.125C16.4583 21.7667 16.7333 21.4917 16.7333 21.1584C16.7333 20.825 16.4583 20.55 16.125 20.55H4.73333Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"0df56b25-de23-4872-8815-91d68ba732ca\"},{\"id\":\"f65e8d49-d6a3-4010-af8d-607a7056c221\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"14000\",\"duration\":\"10000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"Installed Capacity\",\"number_before_after_text\":\"+\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"color\":\"var(--maincolor)\",\"title_margin\":{\"xl\":\"5px 0px 0px 0px\"},\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"500\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":\"#1F1F25\"},\"parent\":\"0df56b25-de23-4872-8815-91d68ba732ca\"},{\"id\":\"7b073c30-0538-491d-8ba3-dc61ac953f0b\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"subtitle\",\"global_custom_css\":\".subtitle span {\\n\\tpadding: 3px 7px;\\n\\tbackground: var(--maincolor);\\n\\tborder-radius: 3px;\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Subtitle\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"<span>About<\\/span> Company\",\"heading_selector\":\"p\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"0px 0px 20px 0px\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"27\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.04\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_animation\":\"fadeInUp\"},\"parent\":\"24372ee8-9db8-46a4-8306-dc8bf9aeb971\"},{\"id\":\"6062b778-87ec-4c38-8b87-3f9e79516da3\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 40px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Section Title\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>we are passionate about transforming the way we power our world. As a leading provider of renewable energy solutions, we are committed to driving the transition to a cleaner, more sustainable future.<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h2\",\"title\":\" Our mission is to make  solar energy accessible\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"48\",\"unit\":\"px\"},\"lg\":{\"value\":\"36\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"32\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"62\",\"unit\":\"px\"},\"lg\":{\"value\":\"50\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"36\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#1F1F25\",\"title_margin_top\":{\"xl\":\"-12\"},\"global_animation\":\"fadeInUp\",\"global_width\":{\"xl\":\"88\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"24372ee8-9db8-46a4-8306-dc8bf9aeb971\"}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"b70a1401-ad38-4e67-a707-8f25ceecb061\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"50%\"},\"class\":\"\"},\"addons\":[{\"id\":\"c93bfcaa-0773-4ff3-b510-26b69e8dc118\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"e7322ce4-da0c-4946-903c-9dd9fc7b3816\",\"66fe583b-d9f2-4fba-bb01-461c859c7a53\",\"b40ce46e-4d0f-4e89-8f5a-9a3005e6dc31\"]},{\"id\":\"e7322ce4-da0c-4946-903c-9dd9fc7b3816\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"full-width-image\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/about\\/22.png\",\"height\":445,\"width\":628,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":0,\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"position\":{\"xl\":\"left\"},\"title\":\"\"},\"parent\":\"c93bfcaa-0773-4ff3-b510-26b69e8dc118\"},{\"id\":\"66fe583b-d9f2-4fba-bb01-461c859c7a53\",\"type\":\"content\",\"name\":\"modal\",\"visibility\":true,\"title\":\"Modal Popup\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M10.294 24.88l4.722 4.752c.73.49 1.663.49 2.394 0l4.721-4.752h5.616c1.138 0 2.253-1.021 2.253-2.48V4.528C29.916 3.008 28.759 2 27.641 2H4.252C3.115 2 2 3.021 2 4.48V22.4c0 1.459 1.115 2.48 2.252 2.48h6.042zM32 4.48V22.4c0 2.464-1.914 4.48-4.253 4.48h-4.784l-4.252 4.28a4.135 4.135 0 01-4.997 0l-4.252-4.28h-5.21C1.914 26.88 0 24.864 0 22.4V4.48C0 2.016 1.914 0 4.252 0h23.39C29.98 0 31.893 2.016 32 4.48z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 10.5a1.5 1.5 0 01-1.5 1.5h-19a1.5 1.5 0 010-3h19a1.5 1.5 0 011.5 1.5zM23 16.5a1.5 1.5 0 01-1.5 1.5h-11a1.5 1.5 0 010-3h11a1.5 1.5 0 011.5 1.5z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"-50\",\"unit\":\"%\"},\"y\":{\"value\":\"-50\",\"unit\":\"%\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"button_text\":\"Launch Modal\",\"modal_selector\":\"icon\",\"button_type\":\"custom\",\"link_button_padding_bottom\":\"\",\"button_appearance\":\"\",\"button_shape\":\"rounded\",\"button_size\":\"\",\"button_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_block\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"\",\"button_style_tab\":\"hover\",\"button_color\":\"#FFFFFF\",\"button_background_color\":\"#3366FF\",\"button_background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"link_button_border_color\":\"\",\"button_color_hover\":\"#FFFFFF\",\"button_background_color_hover\":\"#0037DD\",\"button_background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"selector_image_alt_text\":\"Image\",\"selector_icon_name\":\"fas fa-play\",\"selector_icon_size\":{\"xl\":\"16\"},\"selector_icon_color\":\"var(--maincolor)\",\"selector_text\":\"\",\"selector_text_weight\":\"\",\"selector_text_color\":\"\",\"show_ripple_effect\":1,\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"modal_content_type\":\"video\",\"modal_content_text\":\"Kevin chicken fatback sirloin ball tip, flank meatloaf t-bone. Meatloaf shankle swine pancetta biltong capicola ham hock meatball. Shoulder bacon andouille ground round pancetta pastrami. Sirloin beef ribs tenderloin rump corned beef filet mignon capicola kielbasa drumstick chuck turducken beef t-bone ribeye. Pork loin ground round t-bone chuck beef ribs swine pastrami cow. Venison tenderloin drumstick, filet mignon salami jowl sausage shank hamburger meatball ribeye kevin tri-tip. Swine kielbasa tenderloin fatback pork shankle andouille, flank frankfurter jerky chicken tri-tip jowl leberkas.&lt;br&gt;&lt;br&gt;Pancetta chicken pork belly beef cow kielbasa fatback sirloin biltong andouille bacon. Sirloin beef tenderloin porchetta, jerky tri-tip andouille sausage landjaeger shank bresaola short ribs tongue meatloaf fatback. Kielbasa pancetta shoulder tri-tip pastrami filet mignon ham corned beef prosciutto doner beef ribs. Doner sausage ham hock, shoulder sirloin pancetta boudin filet mignon chuck. Meatball ham hock beef, filet mignon tri-tip andouille venison ground round chuck turducken drumstick.\",\"modal_content_image_alt_text\":\"Image\",\"modal_popup_width\":\"760\",\"modal_popup_height\":\"440\",\"selector_icon_padding\":{\"xl\":\"26\"},\"selector_icon_border_radius\":{\"xl\":\"400\"},\"selector_icon_background\":\"#FFFFFF\",\"selector_icon_border_width\":{\"xl\":\"0\"},\"modal_content_video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=BpkTyus8Ork\"},\"parent\":\"c93bfcaa-0773-4ff3-b510-26b69e8dc118\"},{\"id\":\"b40ce46e-4d0f-4e89-8f5a-9a3005e6dc31\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"10px 18px 10px 18px\"},\"global_margin\":\"\",\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":1,\"global_border_width\":{\"xl\":\"0.5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"72\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"-20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":\"-50\",\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"80\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"Animated Number\",\"number_before_after_text\":\"+\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"45\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"color\":\"#1F1F25\",\"title_margin\":{\"xl\":\"-7px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"21\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":\"#1F1F25\",\"global_boder_style\":\"solid\",\"global_border_color\":\"var(--maincolor)\",\"global_background_color\":\"#FFFFFF\",\"instFormId\":\"b40ce46e-4d0f-4e89-8f5a-9a3005e6dc31\"},\"parent\":\"c93bfcaa-0773-4ff3-b510-26b69e8dc118\"}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":false},{\"id\":\"70010546-b4e2-46a6-8cc0-5d6040f69917\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"120px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"0px 0px 120px 0px\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"services\",\"class\":\"\"},\"layout\":\"12+3+3+3+3\",\"columns\":[{\"id\":\"0d7d337b-c790-46cd-9037-d5887eaaafe0\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"80eb028d-2cd4-450c-8904-63bb1acf1c66\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px -50px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"stok-bg\",\"global_custom_css\":\".stok-bg .sppb-addon-title {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":1,\"hidden_sm\":1,\"hidden_xs\":1,\"acl\":\"\",\"admin_label\":\"Background Moving Text\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Our Services\",\"heading_selector\":\"div\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"100\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_addon_z_index\":\"-1\",\"instFormId\":\"9b69122e-829a-4579-b947-9a1f4e6e232e\",\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":false},{\"id\":\"dc259b10-66f5-481b-9034-e3408496bf8d\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"subtitle\",\"global_custom_css\":\".subtitle span {\\n\\tpadding: 3px 7px;\\n\\tbackground: var(--maincolor);\\n\\tborder-radius: 3px;\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Subtitle\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"<span>Our<\\/span> Service\",\"heading_selector\":\"p\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"0px 0px 20px 0px\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"27\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.04\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_animation\":\"fadeInUp\"},\"parent\":false},{\"id\":\"ac7e127d-7d67-428e-98ea-7c8b41b6ae33\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 20px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Section Title\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p><\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h2\",\"title\":\"Produce Your Own Clean Save<br \\/>The Environment\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"48\",\"unit\":\"px\"},\"lg\":{\"value\":\"36\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"32\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"62\",\"unit\":\"px\"},\"lg\":{\"value\":\"50\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"36\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#1F1F25\",\"title_margin_top\":{\"xl\":\"-12\"},\"global_animation\":\"fadeInUp\",\"global_width\":{\"xl\":\"88\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"alignment\":{\"xl\":\"center\"}},\"parent\":false}]},{\"id\":\"fed1a348-e778-4c9f-b586-f979efe35ae2\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"f7acbd3f-bcf1-4786-a624-7cb614e4a39d\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/20.png\",\"alt\":\"\",\"height\":438,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"scroll\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.1)\",\"ho\":0,\"vo\":\"4\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-solari-service-start\",\"global_custom_css\":\".single-solari-service-start {\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start::before {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #0808087a;\\n\\tz-index: -1;\\n\\ttransition: 0.4s;\\n}\\n\\n.single-solari-service-start::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #ffff;\\n\\tz-index: -1;\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-solari-service-start:hover .icon-area {\\n\\tborder: 1px solid transparent;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start .disc .sppb-addon-content {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .disc .sppb-addon-content {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .sppb-btn-link {\\n\\tcolor: #fdfdfd !important;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\\n\\n.single-solari-service-start .sppb-btn-link:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Service Item\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_addon_z_index\":\"2\"},\"children\":[\"17e6f1ef-14ef-45e3-95f5-410ef5304cd1\",\"587d5fc6-ea5a-4868-9fa5-249afc77f6f1\",\"dc614584-dbfa-48a9-a675-a9f69f73ef0c\",\"e4d67d9a-8d53-425c-b5ef-0077145510b8\"]},{\"id\":\"17e6f1ef-14ef-45e3-95f5-410ef5304cd1\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\".icon-area {\\n  margin-bottom: 90px;\\n  height: 80px;\\n  width: 80px;\\n  background: #fff;\\n  border-radius: 5px;\\n  display: flex;\\n  align-items: center;\\n  justify-content: center;\\n  border: 1px solid var(--maincolor);\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"47\\\" height=\\\"47\\\" viewBox=\\\"0 0 47 47\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M36.0892 5.03606C32.8467 5.03606 30.2142 7.66861 30.2142 10.911C30.2142 14.1535 32.8467 16.786 36.0892 16.786C39.3316 16.786 41.9641 14.1535 41.9641 10.911C41.9641 7.66861 39.3316 5.03606 36.0892 5.03606ZM36.0892 6.71463C38.405 6.71463 40.2855 8.59518 40.2855 10.911C40.2855 13.2269 38.405 15.1074 36.0892 15.1074C33.7733 15.1074 31.8928 13.2269 31.8928 10.911C31.8928 8.59518 33.7733 6.71463 36.0892 6.71463Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M36.9282 20.9823V19.3037C36.9282 18.8404 36.5521 18.4644 36.0889 18.4644C35.6257 18.4644 35.2496 18.8404 35.2496 19.3037V20.9823C35.2496 21.4456 35.6257 21.8216 36.0889 21.8216C36.5521 21.8216 36.9282 21.4456 36.9282 20.9823Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M44.2359 17.8711L42.5573 16.1925C42.2298 15.8652 41.6979 15.8652 41.3703 16.1925C41.0428 16.5198 41.0428 17.0519 41.3703 17.3793L43.0489 19.0578C43.3765 19.3851 43.9083 19.3851 44.2359 19.0578C44.5634 18.7305 44.5634 18.1984 44.2359 17.8711Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M46.1607 10.0716H44.4822C44.019 10.0716 43.6429 10.4476 43.6429 10.9109C43.6429 11.3742 44.019 11.7502 44.4822 11.7502H46.1607C46.6239 11.7502 47 11.3742 47 10.9109C47 10.4476 46.6239 10.0716 46.1607 10.0716Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M43.0489 2.76402L41.3703 4.44258C41.0428 4.7699 41.0428 5.302 41.3703 5.62932C41.6979 5.95664 42.2298 5.95664 42.5573 5.62932L44.2359 3.95076C44.5634 3.62344 44.5634 3.09134 44.2359 2.76402C43.9083 2.4367 43.3765 2.4367 43.0489 2.76402Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M30.8074 4.44258L29.1289 2.76402C28.8013 2.4367 28.2694 2.4367 27.9419 2.76402C27.6144 3.09134 27.6144 3.62344 27.9419 3.95076L29.6204 5.62932C29.948 5.95664 30.4799 5.95664 30.8074 5.62932C31.1349 5.302 31.1349 4.7699 30.8074 4.44258Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M35.2496 0.839403V2.51793C35.2496 2.98123 35.6257 3.35734 36.0889 3.35734C36.5521 3.35734 36.9282 2.98123 36.9282 2.51793V0.839403C36.9282 0.376103 36.5521 0 36.0889 0C35.6257 0 35.2496 0.376103 35.2496 0.839403Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29.6204 16.1925L27.9419 17.8711C27.6144 18.1984 27.6144 18.7305 27.9419 19.0578C28.2694 19.3851 28.8013 19.3851 29.1289 19.0578L30.8074 17.3793C31.1349 17.0519 31.1349 16.5198 30.8074 16.1925C30.4799 15.8652 29.948 15.8652 29.6204 16.1925Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27.6966 10.0716H26.018C25.5548 10.0716 25.1788 10.4476 25.1788 10.9109C25.1788 11.3742 25.5548 11.7502 26.018 11.7502H27.6966C28.1598 11.7502 28.5359 11.3742 28.5359 10.9109C28.5359 10.4476 28.1598 10.0716 27.6966 10.0716Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.28206 25.1787L0.0252364 16.1505C-0.0377095 15.8996 0.0185219 15.6336 0.177985 15.4304C0.336608 15.2265 0.580839 15.1073 0.839336 15.1073H26.0177C26.481 15.1073 26.857 15.4833 26.857 15.9466C26.857 16.4099 26.481 16.7859 26.0177 16.7859H19.5393L21.6375 25.1787H29.1398L28.3509 22.0255C28.2384 21.5757 28.512 21.1199 28.9619 21.0075C29.4109 20.895 29.8675 21.1686 29.9799 21.6176L30.8696 25.1787H37.5318L37.3731 24.5434C37.2607 24.0935 37.5343 23.6378 37.9833 23.5253C38.4331 23.4128 38.8889 23.6865 39.0013 24.1355L39.2624 25.1787H40.2854C40.7487 25.1787 41.1247 25.5547 41.1247 26.018C41.1247 26.4813 40.7487 26.8573 40.2854 26.8573H39.682L41.9388 35.8854C42.0018 36.1363 41.9455 36.4024 41.7861 36.6055C41.6274 36.8095 41.3832 36.9286 41.1247 36.9286H24.3391V45.3214H46.1604C46.6237 45.3214 46.9997 45.6974 46.9997 46.1607C46.9997 46.624 46.6237 47 46.1604 47H0.839336C0.376055 47 5.78268e-05 46.624 5.78268e-05 46.1607C5.78268e-05 45.6974 0.376055 45.3214 0.839336 45.3214H17.6249V36.9286H5.87501C5.48978 36.9286 5.15407 36.6668 5.06091 36.2933L2.7017 26.8573H1.67862C1.21533 26.8573 0.839336 26.4813 0.839336 26.018C0.839336 25.5547 1.21533 25.1787 1.67862 25.1787H2.28206ZM19.3035 36.9286V45.3214H22.6606V36.9286H19.3035ZM13.1927 35.2501L11.0945 26.8573H4.43229L6.53048 35.2501H13.1927ZM12.8251 26.8573L14.9233 35.2501H22.4247L20.3265 26.8573H12.8251ZM22.0571 26.8573L24.1553 35.2501H31.6568L29.5586 26.8573H22.0571ZM37.9514 26.8573H31.2892L33.3874 35.2501H40.0496L37.9514 26.8573ZM1.91445 16.7859L4.01265 25.1787H10.6757L8.57749 16.7859H1.91445ZM10.3072 16.7859L12.4054 25.1787H19.9077L17.8095 16.7859H10.3072Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\"},\"parent\":\"f7acbd3f-bcf1-4786-a624-7cb614e4a39d\"},{\"id\":\"587d5fc6-ea5a-4868-9fa5-249afc77f6f1\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Solar Panel Services\",\"heading_selector\":\"h5\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"#1F1F25\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":\"f7acbd3f-bcf1-4786-a624-7cb614e4a39d\"},{\"id\":\"dc614584-dbfa-48a9-a675-a9f69f73ef0c\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 40px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Acinia phaselus tellus egstas into cursus urna suscpit vehicula otua pellentesque placerat<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"text_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"\"},\"parent\":\"f7acbd3f-bcf1-4786-a624-7cb614e4a39d\"},{\"id\":\"e4d67d9a-8d53-425c-b5ef-0077145510b8\",\"type\":\"general\",\"name\":\"button\",\"visibility\":true,\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Read More\",\"aria_label\":\"\",\"type\":\"link\",\"appearance\":\"\",\"shape\":\"rounded\",\"button_padding\":\"\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"right\",\"icon_margin\":{\"xl\":\"0px 0px 0px 10px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_style_state\":\"normal\",\"color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"background_color\":\"#3366FF\",\"background_color_hover\":\"#0037DD\",\"background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"button_link_style_state\":\"normal\",\"link_button_color\":\"#1F1F25\",\"link_button_border_width\":\"0\",\"link_border_color\":\"\",\"link_button_hover_color\":\"var(--maincolor)\",\"link_button_border_hover_color\":\"\",\"url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"icon\":\"fas fa-arrow-right\"},\"parent\":\"f7acbd3f-bcf1-4786-a624-7cb614e4a39d\"}]},{\"id\":\"dc9d1c13-ea9c-4dde-aadb-8dd686938720\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"a76e5e1c-85da-4ee2-bea7-b80c1a125a41\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/29.png\",\"alt\":\"\",\"height\":438,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"scroll\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.1)\",\"ho\":0,\"vo\":\"4\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-solari-service-start\",\"global_custom_css\":\".single-solari-service-start {\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start::before {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #0808087a;\\n\\tz-index: -1;\\n\\ttransition: 0.4s;\\n}\\n\\n.single-solari-service-start::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #ffff;\\n\\tz-index: -1;\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-solari-service-start:hover .icon-area {\\n\\tborder: 1px solid transparent;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start .disc .sppb-addon-content {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .disc .sppb-addon-content {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .sppb-btn-link {\\n\\tcolor: #fdfdfd !important;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\\n\\n.single-solari-service-start .sppb-btn-link:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Service Item\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_addon_z_index\":\"2\"},\"children\":[\"5c9e17b4-5642-4718-b9e3-64b0ba1596d5\",\"e5a3c94e-d9f5-46f8-96ff-e6684a068d5c\",\"69beed03-dbb5-4d11-8754-c6eab6d5da43\",\"780004c5-e2c6-4736-8c83-35339629ddf0\"],\"parent\":false},{\"id\":\"5c9e17b4-5642-4718-b9e3-64b0ba1596d5\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\".icon-area {\\n  margin-bottom: 90px;\\n  height: 80px;\\n  width: 80px;\\n  background: #fff;\\n  border-radius: 5px;\\n  display: flex;\\n  align-items: center;\\n  justify-content: center;\\n  border: 1px solid var(--maincolor);\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"51\\\" height=\\\"36\\\" viewBox=\\\"0 0 51 36\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<path d=\\\"M50.1691 18.2293L35.9942 4.14235C35.9658 4.11417 35.9446 4.10087 35.921 4.08678C35.7855 3.97957 35.6186 3.91304 35.4374 3.91304H33.401L35.9942 1.33591C36.2194 1.11209 36.2871 0.775565 36.1651 0.482869C36.0438 0.190174 35.7564 0 35.4374 0H14.9626C14.7531 0 14.5531 0.0821741 14.4058 0.229305L0.230885 14.3163C0.0056615 14.5401 -0.0620631 14.8766 0.0599987 15.1693C0.18206 15.462 0.469496 15.6522 0.787644 15.6522H2.82411L0.230885 18.2293C0.0056615 18.4531 -0.0620631 18.7897 0.0599987 19.0823C0.18206 19.375 0.469496 19.5652 0.787644 19.5652H2.36263V35.2174C2.36263 35.6502 2.71465 36 3.15013 36H47.2499C47.6854 36 48.0374 35.6502 48.0374 35.2174V19.5652H49.6124C49.9305 19.5652 50.2179 19.375 50.34 19.0823C50.4621 18.7897 50.3943 18.4531 50.1691 18.2293ZM28.024 7.04348H23.1635L28.676 1.56522H33.5364L28.024 7.04348ZM8.98862 14.087L14.5011 8.6087H19.3615L13.849 14.087H8.98862ZM26.449 1.56522L20.9365 7.04348H16.0761L21.5885 1.56522H26.449ZM21.5885 8.6087H26.449L20.9365 14.087H16.0761L21.5885 8.6087ZM15.2886 1.56522H19.3615L13.849 7.04348H9.77611L15.2886 1.56522ZM8.20112 8.6087H12.2741L6.76158 14.087H2.68866L8.20112 8.6087ZM5.05114 15.6522H21.2625C21.472 15.6522 21.6712 15.5692 21.8193 15.4229L31.826 5.47826H33.5364L20.9365 18H2.68866L5.05114 15.6522ZM3.93763 19.5652H22.8375V34.4348H3.93763V19.5652ZM32.2875 34.4348V23.4783H38.5874V34.4348H32.2875ZM47.2499 18C46.8144 18 46.4624 18.3498 46.4624 18.7826V34.4348H40.1624V22.6957C40.1624 22.2629 39.8104 21.913 39.3749 21.913H31.5C31.0645 21.913 30.7125 22.2629 30.7125 22.6957V34.4348H24.4125V18.7826C24.4125 18.3498 24.0605 18 23.625 18H23.1635L35.4374 5.80226L47.7113 18H47.2499Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M35.4374 11.7391C33.2663 11.7391 31.5 13.4945 31.5 15.6522C31.5 17.8098 33.2663 19.5652 35.4374 19.5652C37.6086 19.5652 39.3749 17.8098 39.3749 15.6522C39.3749 13.4945 37.6086 11.7391 35.4374 11.7391ZM35.4374 18C34.1349 18 33.075 16.9466 33.075 15.6522C33.075 14.3577 34.1349 13.3043 35.4374 13.3043C36.74 13.3043 37.7999 14.3577 37.7999 15.6522C37.7999 16.9474 36.7407 18 35.4374 18Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M20.475 21.913H6.30011C5.86463 21.913 5.51262 22.2629 5.51262 22.6957V30.5217C5.51262 30.9545 5.86463 31.3043 6.30011 31.3043H20.475C20.9105 31.3043 21.2625 30.9545 21.2625 30.5217V22.6957C21.2625 22.2637 20.9105 21.913 20.475 21.913ZM7.08761 23.4783H12.6001V29.7391H7.08761V23.4783ZM19.6875 29.7391H14.1751V23.4783H19.6875V29.7391Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\"},\"parent\":\"a76e5e1c-85da-4ee2-bea7-b80c1a125a41\"},{\"id\":\"e5a3c94e-d9f5-46f8-96ff-e6684a068d5c\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Turbines Services\",\"heading_selector\":\"h5\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"#1F1F25\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":\"a76e5e1c-85da-4ee2-bea7-b80c1a125a41\"},{\"id\":\"69beed03-dbb5-4d11-8754-c6eab6d5da43\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 40px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Acinia phaselus tellus egstas into cursus urna suscpit vehicula otua pellentesque placerat<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"text_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"\"},\"parent\":\"a76e5e1c-85da-4ee2-bea7-b80c1a125a41\"},{\"id\":\"780004c5-e2c6-4736-8c83-35339629ddf0\",\"type\":\"general\",\"name\":\"button\",\"visibility\":true,\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Read More\",\"aria_label\":\"\",\"type\":\"link\",\"appearance\":\"\",\"shape\":\"rounded\",\"button_padding\":\"\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"right\",\"icon_margin\":{\"xl\":\"0px 0px 0px 10px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_style_state\":\"normal\",\"color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"background_color\":\"#3366FF\",\"background_color_hover\":\"#0037DD\",\"background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"button_link_style_state\":\"normal\",\"link_button_color\":\"#1F1F25\",\"link_button_border_width\":\"0\",\"link_border_color\":\"\",\"link_button_hover_color\":\"var(--maincolor)\",\"link_button_border_hover_color\":\"\",\"url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"icon\":\"fas fa-arrow-right\"},\"parent\":\"a76e5e1c-85da-4ee2-bea7-b80c1a125a41\"}]},{\"id\":\"f2fe5caa-b54b-4cfc-8ea2-2a62229884fe\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"11da309c-2848-410a-8629-044c71e05151\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/30.png\",\"alt\":\"\",\"height\":438,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"scroll\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.1)\",\"ho\":0,\"vo\":\"4\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-solari-service-start\",\"global_custom_css\":\".single-solari-service-start {\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start::before {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #0808087a;\\n\\tz-index: -1;\\n\\ttransition: 0.4s;\\n}\\n\\n.single-solari-service-start::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #ffff;\\n\\tz-index: -1;\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-solari-service-start:hover .icon-area {\\n\\tborder: 1px solid transparent;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start .disc .sppb-addon-content {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .disc .sppb-addon-content {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .sppb-btn-link {\\n\\tcolor: #fdfdfd !important;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\\n\\n.single-solari-service-start .sppb-btn-link:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Service Item\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_addon_z_index\":\"2\"},\"children\":[\"ec0bd306-8767-4192-9413-226220f28e5a\",\"920f0696-0394-4970-824c-8cb35f133edc\",\"d7cbbe0d-e670-404d-9cd3-9c1a63cd3169\",\"27bde522-00f7-4b16-ad69-0f054ea1957b\"],\"parent\":false},{\"id\":\"ec0bd306-8767-4192-9413-226220f28e5a\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\".icon-area {\\n  margin-bottom: 90px;\\n  height: 80px;\\n  width: 80px;\\n  background: #fff;\\n  border-radius: 5px;\\n  display: flex;\\n  align-items: center;\\n  justify-content: center;\\n  border: 1px solid var(--maincolor);\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"42\\\" height=\\\"50\\\" viewBox=\\\"0 0 42 50\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<path d=\\\"M40.8102 37.8259C36.0781 30.9957 33.4281 28.0137 28.7885 24.3587C28.8154 24.1383 28.831 23.9143 28.831 23.6866C28.831 22.4547 28.4237 21.3174 27.7387 20.4038C29.9488 14.8933 30.7684 10.9722 31.4869 2.66552C31.5899 1.4783 30.8378 0.392738 29.6986 0.0842372C28.5594 -0.224263 27.3709 0.335901 26.8727 1.4159C23.3854 8.97157 22.1548 12.7815 21.3421 18.6685C20.054 19.2205 19.0206 20.2648 18.4743 21.5665C12.6485 22.3876 8.87811 23.6313 1.40145 27.1551C0.332404 27.6586 -0.221931 28.8596 0.0833588 30.0108C0.380048 31.1297 1.48997 31.9192 2.63769 31.818C10.7437 31.102 14.6295 30.2867 19.9647 28.1228L18.6881 45.2432H18.0029C16.9902 45.2432 16.1663 46.0757 16.1663 47.0991V49.2187C16.1663 49.6502 16.5125 50 16.9395 50H29.2613C29.6883 50 30.0345 49.6502 30.0345 49.2187V47.0991C30.0345 46.0757 29.2106 45.2432 28.1979 45.2432H27.5127L26.5277 32.0324C29.2653 35.1096 32.2135 37.5471 37.4322 41.239C37.8537 41.5375 38.34 41.6837 38.8236 41.6837C39.4482 41.6837 40.0684 41.4396 40.5385 40.9647C41.3725 40.1219 41.4867 38.8019 40.8102 37.8259ZM28.2742 2.07626C28.4577 1.6784 28.8788 1.47996 29.2984 1.59363C29.718 1.70721 29.9845 2.09198 29.9466 2.52939C29.2699 10.3524 28.5065 14.1868 26.5374 19.2321C25.6604 18.6076 24.5924 18.2392 23.4403 18.2392C23.2792 18.2392 23.1202 18.2477 22.9626 18.2617C23.7536 12.8986 24.9899 9.19218 28.2742 2.07626ZM23.4402 19.8016C25.5602 19.8016 27.2848 21.5444 27.2848 23.6866C27.2848 25.8288 25.5602 27.5716 23.4402 27.5716C21.3203 27.5716 19.5956 25.8288 19.5956 23.6866C19.5956 21.5444 21.3204 19.8016 23.4402 19.8016ZM2.50297 30.2614C2.0704 30.2998 1.68954 30.0304 1.57714 29.6064C1.46465 29.1824 1.66113 28.7568 2.05504 28.5713C9.09662 25.2526 12.7645 24.0032 18.0718 23.2038C18.0579 23.363 18.0495 23.5237 18.0495 23.6865C18.0495 24.8507 18.4139 25.9299 19.032 26.8162C14.0391 28.8061 10.2446 29.5775 2.50297 30.2614ZM28.4883 47.0991V48.4375H17.7127V47.0991C17.7127 46.9401 17.8456 46.8057 18.003 46.8057H28.198C28.3553 46.8057 28.4883 46.9401 28.4883 47.0991ZM25.9622 45.2432H20.2389L21.4684 28.7551C22.0795 28.9987 22.7443 29.1342 23.4402 29.1342C23.6656 29.1342 23.8872 29.1184 24.1054 29.0912C24.3482 29.406 24.5881 29.7117 24.8263 30.0096L25.9622 45.2432ZM39.4451 39.8598C39.138 40.1703 38.6751 40.2112 38.3191 39.9591C31.9539 35.4559 29.0494 32.8708 25.7105 28.6258C26.861 28.0836 27.7914 27.1433 28.328 25.9807C32.5288 29.3547 35.0872 32.2899 39.5436 38.7221C39.7928 39.0816 39.7523 39.5495 39.4451 39.8598ZM32.8658 11.0029C33.139 10.6712 33.6264 10.626 33.9545 10.902C36.3376 12.9057 38.1087 15.542 39.0762 18.5258C40.0697 21.5892 40.1565 24.8613 39.3273 27.9884C39.1994 28.4707 39.0454 28.9601 38.8696 29.4428C38.7546 29.7587 38.4588 29.9545 38.1439 29.9545C38.0553 29.9545 37.9651 29.939 37.8771 29.9063C37.4764 29.7573 37.2711 29.3082 37.4184 28.9033C37.5781 28.4647 37.7178 28.0209 37.8336 27.584C39.3336 21.9275 37.4227 15.8509 32.9654 12.1032C32.6374 11.8271 32.5927 11.3345 32.8658 11.0029ZM7.2297 20.8758C7.31639 20.3686 7.42511 19.8669 7.55306 19.3848C8.38225 16.2578 10.0764 13.468 12.4525 11.317C14.7669 9.22177 17.6051 7.83357 20.6603 7.30231C21.0814 7.22926 21.4809 7.51452 21.5534 7.93982C21.6258 8.36502 21.3434 8.76903 20.9225 8.84227C15.2081 9.83594 10.5465 14.1329 9.04666 19.7893C8.93078 20.226 8.83211 20.681 8.75344 21.1418C8.6885 21.5219 8.36176 21.7902 7.99249 21.7902C7.94881 21.7902 7.90455 21.7864 7.86 21.7787C7.43932 21.7053 7.15703 21.301 7.2297 20.8758ZM16.3693 38.6077C16.2523 38.6077 16.1336 38.5809 16.0219 38.524C14.0006 37.4944 12.2404 36.0768 10.7901 34.3104C10.5174 33.9784 10.5628 33.4858 10.8913 33.2103C11.22 32.9346 11.7074 32.9806 11.98 33.3126C13.2937 34.9126 14.8877 36.1966 16.7179 37.1287C17.0992 37.3229 17.2525 37.7927 17.0603 38.178C16.9243 38.4504 16.6519 38.6077 16.3693 38.6077ZM20.1248 13.0292C20.2813 13.4307 20.0862 13.8843 19.689 14.0425C17.0411 15.0971 14.9301 17.23 13.8972 19.8943C13.7777 20.2024 13.486 20.3908 13.1771 20.3908C13.0833 20.3908 12.9879 20.3734 12.8953 20.3368C12.4977 20.1795 12.3016 19.7261 12.4574 19.3244C13.6465 16.2571 16.0756 13.8021 19.1219 12.5888C19.5191 12.4306 19.9681 12.6278 20.1248 13.0292ZM31.5848 16.1323C31.919 15.8637 32.4054 15.9199 32.6711 16.2576C34.709 18.8476 35.5979 22.201 35.11 25.4579C35.052 25.845 34.7223 26.1224 34.3465 26.1224C34.308 26.1224 34.2691 26.1195 34.2299 26.1135C33.8076 26.049 33.5172 25.6507 33.5812 25.2242C34.005 22.395 33.2322 19.4813 31.4609 17.2301C31.195 16.8923 31.2506 16.4008 31.5848 16.1323Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\"},\"parent\":\"11da309c-2848-410a-8629-044c71e05151\"},{\"id\":\"920f0696-0394-4970-824c-8cb35f133edc\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Hydropower Plants\",\"heading_selector\":\"h5\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"#1F1F25\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":\"11da309c-2848-410a-8629-044c71e05151\"},{\"id\":\"d7cbbe0d-e670-404d-9cd3-9c1a63cd3169\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 40px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Acinia phaselus tellus egstas into cursus urna suscpit vehicula otua pellentesque placerat<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"text_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"\"},\"parent\":\"11da309c-2848-410a-8629-044c71e05151\"},{\"id\":\"27bde522-00f7-4b16-ad69-0f054ea1957b\",\"type\":\"general\",\"name\":\"button\",\"visibility\":true,\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Read More\",\"aria_label\":\"\",\"type\":\"link\",\"appearance\":\"\",\"shape\":\"rounded\",\"button_padding\":\"\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"right\",\"icon_margin\":{\"xl\":\"0px 0px 0px 10px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_style_state\":\"normal\",\"color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"background_color\":\"#3366FF\",\"background_color_hover\":\"#0037DD\",\"background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"button_link_style_state\":\"normal\",\"link_button_color\":\"#1F1F25\",\"link_button_border_width\":\"0\",\"link_border_color\":\"\",\"link_button_hover_color\":\"var(--maincolor)\",\"link_button_border_hover_color\":\"\",\"url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"icon\":\"fas fa-arrow-right\"},\"parent\":\"11da309c-2848-410a-8629-044c71e05151\"}]},{\"id\":\"77c68960-7fa1-45b7-ab07-effe81b16160\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"902001fd-ad96-4c0a-8686-87a9c7c2f277\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/service\\/31.png\",\"alt\":\"\",\"height\":438,\"width\":312},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"scroll\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"10\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"enabled\":true,\"color\":\"rgba(0, 0, 0, 0.1)\",\"ho\":0,\"vo\":\"4\",\"blur\":\"34\",\"spread\":0,\"inset\":false},\"class\":\"single-solari-service-start\",\"global_custom_css\":\".single-solari-service-start {\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start::before {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #0808087a;\\n\\tz-index: -1;\\n\\ttransition: 0.4s;\\n}\\n\\n.single-solari-service-start::after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tleft: 0;\\n\\ttop: 0;\\n\\twidth: 100%;\\n\\theight: 100%;\\n\\tbackground: #ffff;\\n\\tz-index: -1;\\n\\ttransition: 0.6s;\\n}\\n\\n.single-solari-service-start:hover::after {\\n\\theight: 0%;\\n}\\n\\n.single-solari-service-start:hover .icon-area {\\n\\tborder: 1px solid transparent;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start .disc .sppb-addon-content {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-solari-service-start:hover .title .sppb-addon-title {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .disc .sppb-addon-content {\\n\\tcolor: #fff;\\n}\\n\\n.single-solari-service-start:hover .sppb-btn-link {\\n\\tcolor: #fdfdfd !important;\\n}\\n\\n.single-solari-service-start .title .sppb-addon-title:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\\n\\n.single-solari-service-start .sppb-btn-link:hover {\\n\\tcolor: var(--maincolor) !important;\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Service Item\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"hidden\",\"global_addon_z_index\":\"2\"},\"children\":[\"fd079021-9e46-47df-bf41-fe6fa564d0f8\",\"c7ba13f3-de42-414f-ac27-35d065ced056\",\"d1c0e11d-5c2e-4c8e-ba2d-01e7bcf20ae8\",\"176df28f-10ca-48ff-845d-96e73152c932\"],\"parent\":false},{\"id\":\"fd079021-9e46-47df-bf41-fe6fa564d0f8\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"icon-area\",\"global_custom_css\":\".icon-area {\\n  margin-bottom: 90px;\\n  height: 80px;\\n  width: 80px;\\n  background: #fff;\\n  border-radius: 5px;\\n  display: flex;\\n  align-items: center;\\n  justify-content: center;\\n  border: 1px solid var(--maincolor);\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Icon\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"46\\\" height=\\\"46\\\" viewBox=\\\"0 0 46 46\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n<path d=\\\"M36.339 21.9L36.8359 20.4494L38.2869 20.9463L37.79 22.3969L36.339 21.9Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M45.2333 41.4002H43.7V36.0335H44.4667C44.67 36.0335 44.865 35.9528 45.0088 35.809C45.1526 35.6652 45.2333 35.4702 45.2333 35.2669V29.1335C45.2333 28.9302 45.1526 28.7352 45.0088 28.5914C44.865 28.4477 44.67 28.3669 44.4667 28.3669H43.7V18.7282C44.0543 17.9526 44.3632 17.1571 44.6254 16.3458C46.2725 11.2622 46.4372 6.35409 45.1151 1.75784C45.0692 1.59789 44.9725 1.45723 44.8395 1.35714C44.7066 1.25704 44.5447 1.20296 44.3783 1.20306H40.5727C40.4096 1.20299 40.2507 1.25494 40.1192 1.35135C39.9876 1.44775 39.8902 1.5836 39.8412 1.73915L37.1309 10.3258L7.10585 0.041465C7.01058 0.00879203 6.90981 -0.00479036 6.80929 0.00149402C6.70878 0.00777839 6.61048 0.0338063 6.52003 0.0780907C6.42957 0.122375 6.34873 0.184048 6.28211 0.259586C6.2155 0.335124 6.16442 0.423047 6.1318 0.518331L4.64121 4.87012C4.6085 4.96536 4.59489 5.06612 4.60116 5.16663C4.60743 5.26714 4.63346 5.36543 4.67775 5.45587C4.72204 5.54631 4.78373 5.62713 4.85928 5.69371C4.93484 5.76029 5.02278 5.81132 5.11807 5.84388L19.1757 10.6591L19.5123 13.1639C19.371 13.2557 19.2642 13.3918 19.2086 13.5509C16.3891 21.7524 11.8717 34.9865 10.9171 38.3333H9.2C8.99667 38.3333 8.80166 38.4141 8.65788 38.5579C8.51411 38.7017 8.43333 38.8967 8.43333 39.1V41.4H0.766667C0.563334 41.4 0.368329 41.4808 0.224551 41.6246C0.0807735 41.7683 0 41.9633 0 42.1667V45.2333C0 45.4367 0.0807735 45.6317 0.224551 45.7754C0.368329 45.9192 0.563334 46 0.766667 46H45.2333C45.4367 46 45.6317 45.9192 45.7754 45.7754C45.9192 45.6317 46 45.4367 46 45.2333V42.1669C46 41.9635 45.9192 41.7685 45.7754 41.6247C45.6317 41.481 45.4367 41.4002 45.2333 41.4002ZM43.7 34.5002H42.1667V29.9002H43.7V34.5002ZM42.1667 28.3669H41.4C41.1967 28.3669 41.0017 28.4477 40.8579 28.5914C40.7141 28.7352 40.6333 28.9302 40.6333 29.1335V35.2669C40.6333 35.4702 40.7141 35.6652 40.8579 35.809C41.0017 35.9528 41.1967 36.0335 41.4 36.0335H42.1667V41.4002H28.3667V39.1002C28.3667 38.8969 28.2859 38.7019 28.1421 38.5581C27.9983 38.4143 27.8033 38.3335 27.6 38.3335H26.8333V13.9344L27.3252 13.4506L35.2841 16.1769L32.2352 25.8369C32.1757 26.0255 32.1914 26.2298 32.279 26.4072C32.3666 26.5845 32.5194 26.7211 32.7053 26.7884L34.5614 27.4604C34.6699 27.4996 34.7857 27.5139 34.9005 27.5021C35.0152 27.4904 35.1258 27.453 35.224 27.3926C37.9423 25.7241 40.3041 24.096 42.1667 21.4311V28.3669ZM16.0425 27.5906C16.0621 27.5922 16.0799 27.6002 16.1 27.6002H22.8188L14.67 31.6747C15.096 30.4004 15.5593 29.0226 16.0425 27.5906ZM18.1203 21.4669H23.3578L16.7358 25.5421C17.1911 24.1981 17.6564 22.8286 18.1203 21.4669ZM24.4034 16.1516C24.6531 16.015 24.8839 15.8462 25.0896 15.6495L25.3 15.4426V19.9336H19.7813L24.4034 16.1516ZM25.3 26.0669H18.8088L25.3 22.0723V26.0669ZM25.3 32.2002H17.0479L25.3 28.0741V32.2002ZM13.9845 33.7335H22.27L12.6683 37.7764C12.9716 36.8106 13.4289 35.4097 13.9845 33.7335ZM25.3 34.1216V38.3335H15.2966L25.3 34.1216ZM41.1349 2.7362H43.7929C44.8612 6.87418 44.6516 11.2907 43.167 15.8728C42.8915 16.7361 42.5597 17.5804 42.1737 18.4002H42.1667V18.4159C40.5713 21.7568 38.3123 23.6682 34.7351 25.8917L33.9191 25.5963L36.9602 15.9617C36.965 15.9489 36.9756 15.9395 36.9794 15.9266L38.3623 11.5374C38.3652 11.5278 38.3623 11.5187 38.3653 11.5093L41.1349 2.7362ZM6.34072 4.64184L7.33422 1.74059L36.6693 11.7884L35.7458 14.7137L27.3738 11.8461C27.2391 11.8001 27.0943 11.7925 26.9555 11.8241C26.8167 11.8557 26.6895 11.9253 26.588 12.0251L24.4222 14.1558L23.5436 14.8745C23.3009 14.9923 23.0337 15.0507 22.764 15.0448C22.4943 15.039 22.2299 14.9691 21.9925 14.841C21.7552 14.7128 21.5517 14.53 21.3989 14.3078C21.2461 14.0855 21.1483 13.8301 21.1136 13.5626L20.6329 9.98521C20.6139 9.84415 20.556 9.71116 20.4657 9.60114C20.3754 9.49112 20.2562 9.40842 20.1215 9.3623L6.34072 4.64184ZM20.2296 15.2975C20.6054 15.7931 21.1163 16.1696 21.701 16.3818L19.1407 18.4769C19.5139 17.3853 19.8788 16.3197 20.2296 15.2975ZM9.96667 39.8669H26.8333V41.4002H9.96667V39.8669ZM44.4667 44.4669H1.53333V42.9335H44.4667V44.4669Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<path d=\\\"M22.025 13.2553L22.5219 11.8047L23.9729 12.3017L23.476 13.7523L22.025 13.2553Z\\\" fill=\\\"#4AAB3D\\\"><\\/path>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\"},\"parent\":\"902001fd-ad96-4c0a-8686-87a9c7c2f277\"},{\"id\":\"c7ba13f3-de42-414f-ac27-35d065ced056\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"title\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Fossil Resources\",\"heading_selector\":\"h5\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"#1F1F25\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":\"902001fd-ad96-4c0a-8686-87a9c7c2f277\"},{\"id\":\"d1c0e11d-5c2e-4c8e-ba2d-01e7bcf20ae8\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 40px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"disc\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>Acinia phaselus tellus egstas into cursus urna suscpit vehicula otua pellentesque placerat<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"text_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title\":\"\"},\"parent\":\"902001fd-ad96-4c0a-8686-87a9c7c2f277\"},{\"id\":\"176df28f-10ca-48ff-845d-96e73152c932\",\"type\":\"general\",\"name\":\"button\",\"visibility\":true,\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Read More\",\"aria_label\":\"\",\"type\":\"link\",\"appearance\":\"\",\"shape\":\"rounded\",\"button_padding\":\"\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"right\",\"icon_margin\":{\"xl\":\"0px 0px 0px 10px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_style_state\":\"normal\",\"color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"background_color\":\"#3366FF\",\"background_color_hover\":\"#0037DD\",\"background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"button_link_style_state\":\"normal\",\"link_button_color\":\"#1F1F25\",\"link_button_border_width\":\"0\",\"link_border_color\":\"\",\"link_button_hover_color\":\"var(--maincolor)\",\"link_button_border_hover_color\":\"\",\"url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=152\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"icon\":\"fas fa-arrow-right\"},\"parent\":\"902001fd-ad96-4c0a-8686-87a9c7c2f277\"}]}],\"parent\":false},{\"id\":\"e9fa68be-3b8f-4de3-9528-25c116397527\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"120px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"12+4+4+4\",\"columns\":[{\"id\":\"b0b229c7-fe5b-4f28-86bb-d659a1ed6ea9\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"5c8d676e-754d-4c8c-a46a-f8d514c27ca0\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px -50px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"stok-bg\",\"global_custom_css\":\".stok-bg .sppb-addon-title {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":1,\"hidden_sm\":1,\"hidden_xs\":1,\"acl\":\"\",\"admin_label\":\"Background Moving Text\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Work Process\",\"heading_selector\":\"div\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"100\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_addon_z_index\":\"-1\",\"instFormId\":\"9b69122e-829a-4579-b947-9a1f4e6e232e\",\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":false},{\"id\":\"40d4cf31-ae14-4a00-9116-8afb32ed85ad\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"subtitle\",\"global_custom_css\":\".subtitle span {\\n\\tpadding: 3px 7px;\\n\\tbackground: var(--maincolor);\\n\\tborder-radius: 3px;\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Subtitle\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"<span>Our<\\/span> Working Process\",\"heading_selector\":\"p\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"0px 0px 20px 0px\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"27\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.04\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_animation\":\"fadeInUp\"},\"parent\":false},{\"id\":\"39e48010-cc58-4957-8a4d-583fe41926af\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 20px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Section Title\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p><\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h2\",\"title\":\"Wind Solar Energy work<br \\/>Project Planning\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"48\",\"unit\":\"px\"},\"lg\":{\"value\":\"36\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"32\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"62\",\"unit\":\"px\"},\"lg\":{\"value\":\"50\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"36\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#1F1F25\",\"title_margin_top\":{\"xl\":\"-12\"},\"global_animation\":\"fadeInUp\",\"global_width\":{\"xl\":\"88\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"alignment\":{\"xl\":\"center\"}},\"parent\":false}]},{\"id\":\"b09921b1-b7d7-471a-a1a8-f37ed0bdd550\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"33.333333%\",\"lg\":\"33.333333%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"5e564631-b536-470d-9b68-7a52f2ebe8b7\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"30px 0px 30px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"steps position-relative overflow-hidden full-width-image\",\"global_custom_css\":\".steps {\\nborder-radius: 10px;\\n}\\n\\n.steps .sppb-addon-single-image-container {\\n  display: block;\\n}\\n\\n.steps .sppb-addon-title {\\nposition: absolute;\\nz-index: 2;\\n  left: 0;\\n  bottom: 0;\\n  width: 88px;\\n  height: 72px;\\n  display: flex;\\n  align-items: center;\\n  background: #fff;\\n  justify-content: center;\\n  border-radius: 0 10px 0 0;\\n\\t-webkit-text-stroke-width: 0.5px;\\n\\t-webkit-text-stroke-color: var(--maincolor);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/steps\\/01.png\",\"height\":260,\"width\":424,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":\"10\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":1,\"zoom_scale\":\"1.1\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"div\",\"title_position\":\"top\",\"title\":\"01\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"900\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.05\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#FFFFFF\",\"image_effects\":[]}},{\"id\":\"f7a4f244-2b71-4035-88dc-54585636badf\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Project Planning\",\"heading_selector\":\"h5\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}}}]},{\"id\":\"781623bc-42ac-4141-b61d-8d0109b46d9b\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"33.333333%\",\"lg\":\"33.333333%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"ffe208b9-b3ce-495b-a7fc-679127ba82f6\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"30px 0px 30px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"steps position-relative overflow-hidden full-width-image\",\"global_custom_css\":\".steps {\\nborder-radius: 10px;\\n}\\n\\n.steps .sppb-addon-single-image-container {\\n  display: block;\\n}\\n\\n.steps .sppb-addon-title {\\nposition: absolute;\\nz-index: 2;\\n  left: 0;\\n  bottom: 0;\\n  width: 88px;\\n  height: 72px;\\n  display: flex;\\n  align-items: center;\\n  background: #fff;\\n  justify-content: center;\\n  border-radius: 0 10px 0 0;\\n\\t-webkit-text-stroke-width: 0.5px;\\n\\t-webkit-text-stroke-color: var(--maincolor);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/steps\\/02.png\",\"height\":260,\"width\":424,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":\"10\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":1,\"zoom_scale\":\"1.1\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"div\",\"title_position\":\"top\",\"title\":\"02\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"900\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.05\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#FFFFFF\",\"image_effects\":[]}},{\"id\":\"150847b5-6c82-4ca8-bdfd-f4149efd7c71\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Research & Analysis\",\"heading_selector\":\"h5\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}}}]},{\"id\":\"129d18b0-fcfb-42e7-9893-ca9128b1c1c8\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"33.333333%\",\"lg\":\"33.333333%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"7da5fb69-056a-4819-b482-3b54015b046b\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"30px 0px 30px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"steps position-relative overflow-hidden full-width-image\",\"global_custom_css\":\".steps {\\nborder-radius: 10px;\\n}\\n\\n.steps .sppb-addon-single-image-container {\\n  display: block;\\n}\\n\\n.steps .sppb-addon-title {\\nposition: absolute;\\nz-index: 2;\\n  left: 0;\\n  bottom: 0;\\n  width: 88px;\\n  height: 72px;\\n  display: flex;\\n  align-items: center;\\n  background: #fff;\\n  justify-content: center;\\n  border-radius: 0 10px 0 0;\\n\\t-webkit-text-stroke-width: 0.5px;\\n\\t-webkit-text-stroke-color: var(--maincolor);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/steps\\/03.png\",\"height\":260,\"width\":424,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":\"10\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":1,\"zoom_scale\":\"1.1\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"div\",\"title_position\":\"top\",\"title\":\"03\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"900\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.05\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#FFFFFF\",\"image_effects\":[]}},{\"id\":\"0398e716-7b3c-438f-bcac-e8609fd37b6b\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Installation & Maintenance\",\"heading_selector\":\"h5\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}}}]}],\"parent\":false},{\"id\":\"8c15c98c-3932-4fdf-be6e-a19c6adf0cc3\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":\"916936de-1ea2-465f-b00f-1e3afca034c7\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"5bd8263f-1114-4e04-a883-daf1055fbacd\",\"type\":\"nested_row\",\"name\":\"row\",\"title\":\"Row\",\"visibility\":true,\"icon\":\"\"}]}],\"parent\":false},{\"id\":\"f655027d-38c7-456c-a15c-92d1c05e1f4a\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"6+6\",\"columns\":[{\"id\":\"d1562f50-4dd4-469b-8300-fd41b1daa6cb\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"73a19112-e269-4c8e-9672-fcb5e8986d63\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 10% -50px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"stok-bg\",\"global_custom_css\":\".stok-bg .sppb-addon-title {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":1,\"hidden_sm\":1,\"hidden_xs\":1,\"acl\":\"\",\"admin_label\":\"Background Moving Text\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"FAQ\'S\",\"heading_selector\":\"div\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"100\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_addon_z_index\":\"-1\",\"instFormId\":\"9b69122e-829a-4579-b947-9a1f4e6e232e\"},\"parent\":false},{\"id\":\"bd529a24-3d9f-4e9a-9a66-754d8b6953d4\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"subtitle\",\"global_custom_css\":\".subtitle span {\\n\\tpadding: 3px 7px;\\n\\tbackground: var(--maincolor);\\n\\tborder-radius: 3px;\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Subtitle\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"<span>Question<\\/span> For US\",\"heading_selector\":\"p\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"0px 0px 20px 0px\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"27\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.04\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_animation\":\"fadeInUp\"},\"parent\":false},{\"id\":\"ca4df5be-c534-435a-bebc-9f8c510e401b\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 30px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Section Title\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p><\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h2\",\"title\":\"Some General Question?\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"48\",\"unit\":\"px\"},\"lg\":{\"value\":\"36\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"32\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"62\",\"unit\":\"px\"},\"lg\":{\"value\":\"50\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"36\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#1F1F25\",\"title_margin_top\":{\"xl\":\"-12\"},\"global_animation\":\"fadeInUp\",\"global_width\":{\"xl\":\"88\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_margin_bottom\":{\"xl\":\"0\"}},\"parent\":false},{\"id\":\"c19926fd-2c2d-495e-a6d5-8261af19c256\",\"type\":\"repeatable\",\"name\":\"accordion\",\"visibility\":true,\"title\":\"Accordion\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><g opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" fill=\\\"currentColor\\\"><path d=\\\"M32 3c0 .552-.428 1-.956 1H12.956C12.428 4 12 3.552 12 3s.428-1 .956-1h18.088c.528 0 .956.448.956 1zM32 8c0 .552-.428 1-.956 1H12.956C12.428 9 12 8.552 12 8s.428-1 .956-1h18.088c.528 0 .956.448.956 1zM24 13c0 .552-.436 1-.975 1h-10.05A.988.988 0 0112 13c0-.552.437-1 .975-1h10.05c.539 0 .975.448.975 1zM32 24c0 .552-.428 1-.956 1H12.956c-.528 0-.956-.448-.956-1s.428-1 .956-1h18.088c.528 0 .956.448.956 1zM24 29c0 .552-.436 1-.975 1h-10.05A.988.988 0 0112 29c0-.552.437-1 .975-1h10.05c.539 0 .975.448.975 1z\\\"\\/><\\/g><path d=\\\"M.54 2h6.92c.48 0 .72.51.381.81L4.381 5.86a.59.59 0 01-.761 0L.159 2.81c-.34-.3-.1-.81.38-.81zM.54 23h6.92c.48 0 .72.51.381.81l-3.46 3.051a.59.59 0 01-.761 0L.159 23.81c-.34-.3-.1-.81.38-.81z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\".sppb-panel.sppb-panel-custom {\\nbox-shadow: 0px 4px 10px rgba(0, 0, 0, 0.03);\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"sp_accordion_item\":[{\"title\":\"What is solar energy, and how does it work?\",\"content\":[{\"id\":\"84180c16-6ac2-4b6a-82ec-20005948dcd5\",\"type\":\"nested_row\",\"name\":\"row\"}],\"icon\":\"fas fa-angle-double-right\"},{\"title\":\"How much energy can I expect to generate from solar panels?\",\"content\":[{\"id\":\"888c75b0-75df-47d8-84c5-ea2b8bd0b2a3\",\"type\":\"nested_row\",\"name\":\"row\"}],\"icon\":\"fas fa-angle-double-right\",\"admin_label\":\"What is solar energy, and how does it work? copy copy\"},{\"title\":\"Can solar panels work during cloudy or rainy weather?\",\"content\":[{\"id\":\"050eff81-3e2f-4354-879d-859a909a74a3\",\"type\":\"nested_row\",\"name\":\"row\"}],\"icon\":\"fas fa-angle-double-right\",\"admin_label\":\"What is solar energy, and how does it work? copy copy\"},{\"title\":\"Can solar panels work during cloudy or rainy weather?\",\"content\":[{\"id\":\"55e55ea7-1850-40f6-98af-53cf78fcd332\",\"type\":\"nested_row\",\"name\":\"row\"}],\"icon\":\"fas fa-angle-double-right\",\"admin_label\":\"What is solar energy, and how does it work? copy copy\"}],\"style\":\"panel-custom\",\"item_bg\":\"#FFFFFF\",\"item_border_width\":\"0\",\"item_border_color\":\"\",\"item_border_radius\":{\"xl\":\"1\"},\"item_spacing\":{\"xl\":\"20\"},\"active_icon_rotate\":\"90\",\"header_style_tab\":\"active\",\"heading_selector\":\"h3\",\"item_margin\":{\"xl\":\"0px 0px 0px 0px\"},\"item_padding\":{\"xl\":\"10px 25px 10px 25px\"},\"item_title_padding\":{\"xl\":\"1rem 1.25rem 1rem 1.25rem\"},\"icon_position\":\"right\",\"icon_fontsize\":{\"xl\":\"20\"},\"icon_margin\":{\"xl\":\"0px 0px 0px 10px\"},\"item_title_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"22\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"item_title_text_color\":\"#1F1F25\",\"item_content_padding\":{\"xl\":\"1rem 1.25rem 1rem 1.25rem\"},\"title\":\"\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"48\",\"unit\":\"px\"},\"lg\":{\"value\":\"36\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"32\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"62\",\"unit\":\"px\"},\"lg\":{\"value\":\"50\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"36\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"\",\"title_margin_top\":{\"xl\":\"\"},\"title_margin_bottom\":{\"xl\":\"\"},\"active_icon_color\":\"var(--maincolor)\"}},{\"id\":\"e01e8908-54ce-45fc-beaa-7abd0e516df5\",\"type\":\"content\",\"name\":\"empty_space\",\"visibility\":true,\"title\":\"Empty Space\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.5 13.6h-4.9c-.3 0-.5-.4-.3-.7l2.5-2.5c.2-.2.4-.2.5 0l2.5 2.5c.2.2 0 .7-.3.7zM13.5 18.3h4.9c.3 0 .5.4.3.7l-2.5 2.5c-.2.2-.4.2-.5 0L13.2 19c-.2-.3 0-.7.3-.7z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 22.9H2.7c-.9 0-1.7.8-1.7 1.7v5.7c0 .9.8 1.7 1.7 1.7.9 0 1.7-.8 1.7-1.7v-4h22.9v4c0 .9.8 1.7 1.7 1.7.9 0 1.7-.8 1.7-1.7v-5.7c0-1-.8-1.7-1.7-1.7zM29 0c-.9 0-1.7.8-1.7 1.7v4H4.4v-4C4.4.8 3.7 0 2.7 0S1 .8 1 1.7v5.7c0 .9.8 1.7 1.7 1.7H29c.9 0 1.7-.8 1.7-1.7V1.7C30.7.8 29.9 0 29 0z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":1,\"hidden_lg\":1,\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"gap\":{\"xl\":40}}}]},{\"id\":\"982cf1ac-767f-4337-8640-c80ec172ca1b\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"50%\",\"lg\":\"50%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"c1aa7a99-ecc4-4114-a899-299aa7054f23\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/faq\\/05.png\",\"height\":392,\"width\":622,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":0,\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"title\":\"\"},\"parent\":\"9b567408-013e-48bd-acd0-3d9d0e8e9f13\"},{\"id\":\"a460eb40-458a-45a4-89ba-63ee96f24523\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"flex\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"flex-start\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"8eae907a-85a9-4900-893c-07d6fc83e171\",\"c337283e-bfa7-48e0-9554-3e2e07e167d4\"],\"parent\":\"9b567408-013e-48bd-acd0-3d9d0e8e9f13\"},{\"id\":\"9b567408-013e-48bd-acd0-3d9d0e8e9f13\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"0px 0px 0px 40px\",\"lg\":\"0px 0px 0px 0px\"},\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"a460eb40-458a-45a4-89ba-63ee96f24523\",\"c1aa7a99-ecc4-4114-a899-299aa7054f23\"]},{\"id\":\"8eae907a-85a9-4900-893c-07d6fc83e171\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/faq\\/04.png\",\"height\":151,\"width\":224,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":0,\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"position\":{\"xl\":\"left\"},\"title\":\"\"},\"parent\":\"a460eb40-458a-45a4-89ba-63ee96f24523\"},{\"id\":\"c337283e-bfa7-48e0-9554-3e2e07e167d4\",\"type\":\"content\",\"name\":\"modal\",\"visibility\":true,\"title\":\"Modal Popup\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M10.294 24.88l4.722 4.752c.73.49 1.663.49 2.394 0l4.721-4.752h5.616c1.138 0 2.253-1.021 2.253-2.48V4.528C29.916 3.008 28.759 2 27.641 2H4.252C3.115 2 2 3.021 2 4.48V22.4c0 1.459 1.115 2.48 2.252 2.48h6.042zM32 4.48V22.4c0 2.464-1.914 4.48-4.253 4.48h-4.784l-4.252 4.28a4.135 4.135 0 01-4.997 0l-4.252-4.28h-5.21C1.914 26.88 0 24.864 0 22.4V4.48C0 2.016 1.914 0 4.252 0h23.39C29.98 0 31.893 2.016 32 4.48z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M27 10.5a1.5 1.5 0 01-1.5 1.5h-19a1.5 1.5 0 010-3h19a1.5 1.5 0 011.5 1.5zM23 16.5a1.5 1.5 0 01-1.5 1.5h-11a1.5 1.5 0 010-3h11a1.5 1.5 0 011.5 1.5z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 0px -30px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"%\"},\"y\":{\"value\":\"\",\"unit\":\"%\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\".sppb-modal-selector span.text {\\npadding: 0 !important;\\nbackground: transparent !important;\\n}\\n\\n.sppb-ripple-effect {\\n\\tbox-shadow: 0 0 0 15px rgba(74, 171, 61,.8),0 0 0 30px rgba(74, 171, 61,.6),0 0 0 45px rgba(74, 171, 61,.4);\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"button_text\":\"Launch Modal\",\"modal_selector\":\"icon\",\"button_type\":\"custom\",\"link_button_padding_bottom\":\"\",\"button_appearance\":\"\",\"button_shape\":\"rounded\",\"button_size\":\"\",\"button_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_block\":\"\",\"button_icon\":\"\",\"button_icon_position\":\"\",\"button_style_tab\":\"hover\",\"button_color\":\"#FFFFFF\",\"button_background_color\":\"#3366FF\",\"button_background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"link_button_border_color\":\"\",\"button_color_hover\":\"#FFFFFF\",\"button_background_color_hover\":\"#0037DD\",\"button_background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"selector_image_alt_text\":\"Image\",\"selector_icon_name\":\"fas fa-play\",\"selector_icon_size\":{\"xl\":\"16\"},\"selector_icon_color\":\"#FFFFFF\",\"selector_text\":\"Watch Our Intro\",\"selector_text_weight\":\"700\",\"selector_text_color\":\"#000000\",\"show_ripple_effect\":1,\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"modal_content_type\":\"video\",\"modal_content_text\":\"Kevin chicken fatback sirloin ball tip, flank meatloaf t-bone. Meatloaf shankle swine pancetta biltong capicola ham hock meatball. Shoulder bacon andouille ground round pancetta pastrami. Sirloin beef ribs tenderloin rump corned beef filet mignon capicola kielbasa drumstick chuck turducken beef t-bone ribeye. Pork loin ground round t-bone chuck beef ribs swine pastrami cow. Venison tenderloin drumstick, filet mignon salami jowl sausage shank hamburger meatball ribeye kevin tri-tip. Swine kielbasa tenderloin fatback pork shankle andouille, flank frankfurter jerky chicken tri-tip jowl leberkas.&lt;br&gt;&lt;br&gt;Pancetta chicken pork belly beef cow kielbasa fatback sirloin biltong andouille bacon. Sirloin beef tenderloin porchetta, jerky tri-tip andouille sausage landjaeger shank bresaola short ribs tongue meatloaf fatback. Kielbasa pancetta shoulder tri-tip pastrami filet mignon ham corned beef prosciutto doner beef ribs. Doner sausage ham hock, shoulder sirloin pancetta boudin filet mignon chuck. Meatball ham hock beef, filet mignon tri-tip andouille venison ground round chuck turducken drumstick.\",\"modal_content_image_alt_text\":\"Image\",\"modal_popup_width\":\"760\",\"modal_popup_height\":\"440\",\"selector_icon_padding\":{\"xl\":\"22\"},\"selector_icon_border_radius\":{\"xl\":\"400\"},\"selector_icon_background\":\"var(--maincolor)\",\"selector_icon_border_width\":{\"xl\":\"0\"},\"modal_content_video_url\":\"https:\\/\\/www.youtube.com\\/watch?v=BpkTyus8Ork\",\"selector_text_size\":{\"xl\":\"16\"},\"selector_text_margin\":\"0px 0px 0px 30px\"},\"parent\":\"a460eb40-458a-45a4-89ba-63ee96f24523\"}]}],\"parent\":false},{\"id\":\"f6721348-cba5-4952-99af-4bd444fd3eed\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 200px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"project\",\"class\":\"\"},\"layout\":\"12\",\"columns\":[{\"id\":\"b97f5923-b4c5-4ec2-9706-c2170fb308d9\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"13b9a7b9-f043-4fb8-8982-0f5c5eed7866\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px -50px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"stok-bg\",\"global_custom_css\":\".stok-bg .sppb-addon-title {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":1,\"hidden_sm\":1,\"hidden_xs\":1,\"acl\":\"\",\"admin_label\":\"Background Moving Text\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Latest Case\",\"heading_selector\":\"div\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"100\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_addon_z_index\":\"-1\",\"instFormId\":\"9b69122e-829a-4579-b947-9a1f4e6e232e\",\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":false},{\"id\":\"7725be85-9621-411c-bb52-3d03f6e5ba95\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"subtitle\",\"global_custom_css\":\".subtitle span {\\n\\tpadding: 3px 7px;\\n\\tbackground: var(--maincolor);\\n\\tborder-radius: 3px;\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Subtitle\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"<span>Quality Handyman<\\/span> Solution\",\"heading_selector\":\"p\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"0px 0px 20px 0px\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"27\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.04\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_animation\":\"fadeInUp\"},\"parent\":false},{\"id\":\"08a8e950-d792-4220-8db0-8d79a4ca86d2\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 45px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Section Title\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p><\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h2\",\"title\":\"Our Latest Case Studies\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"48\",\"unit\":\"px\"},\"lg\":{\"value\":\"36\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"32\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"62\",\"unit\":\"px\"},\"lg\":{\"value\":\"50\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"36\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#1F1F25\",\"title_margin_top\":{\"xl\":\"-12\"},\"global_animation\":\"fadeInUp\",\"global_width\":{\"xl\":\"88\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"alignment\":{\"xl\":\"center\"}},\"parent\":false},{\"id\":\"c9633503-60f8-4b4a-81be-b06ff22e83fc\",\"type\":\"repeatable\",\"name\":\"image_carousel\",\"visibility\":true,\"title\":\"Image Carousel\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M22 5H10v21h12V5zM10 3a2 2 0 00-2 2v21a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H10z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M23.721 17.693l-3.493 3.636a3.693 3.693 0 01-5.69-.443 1.693 1.693 0 00-2.66-.148L9.752 23.16 8.25 21.84l2.127-2.422a3.693 3.693 0 015.801.322 1.693 1.693 0 002.608.203l3.494-3.636 1.442 1.386zM17.5 9a1.5 1.5 0 100 3 1.5 1.5 0 000-3zM14 10.5a3.5 3.5 0 117 0 3.5 3.5 0 01-7 0zM6 7a1 1 0 00-1-1H1a1 1 0 000 2h3v15H1a1 1 0 100 2h4a1 1 0 001-1V7zm20 17a1 1 0 001 1h4a1 1 0 100-2h-3V8h3a1 1 0 100-2h-4a.996.996 0 00-1 1v17z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"single-case-ac\",\"global_custom_css\":\".single-case-ac .sppb-carousel-extended-description span.pre {\\n\\tfont-weight: 700;\\n\\tfont-size: 14px;\\n\\tline-height: 17px;\\n\\tcolor: #1F1F25;\\n\\tdisplay: block;\\n\\tmargin-bottom: 10px;\\n\\tposition: relative;\\n\\tmax-width: max-content;\\n}\\n\\n.single-case-ac .sppb-carousel-extended-description span.pre:after {\\n\\tposition: absolute;\\n\\tcontent: \\\"\\\";\\n\\tright: -15px;\\n\\ttop: 40%;\\n\\ttransform: translate(50%);\\n\\theight: 1px;\\n\\twidth: 15px;\\n\\tbackground: #1F1F25;\\n}\\n\\n.single-case-ac .sppb-carousel-extended-description .title {\\n\\tfont-weight: 700;\\n\\tfont-size: 24px;\\n\\tline-height: 34px;\\n\\tcolor: #1F1F25;\\n\\tmargin-bottom: 25px;\\n\\ttransition: 0.3s;\\n}\\n\\n@media (max-width: 575px) {\\n.single-case-ac .sppb-carousel-extended-description .title {\\n\\tfont-size: 18px;\\n\\tline-height: 26px;\\n}\\n}\\n\\n.single-case-ac .sppb-carousel-extended-description .title:hover {\\n\\tcolor: var(--maincolor);\\n}\\n\\n.single-case-ac .sppb-carousel-extended-content-wrap {\\n\\ttop: auto;\\n\\tpadding: 0px;\\n\\tleft: 30px !important;\\n\\tbottom: -20px;\\n\\twidth: 87%;\\n\\theight: 97px;\\n\\tbackground: #FFFFFF;\\n\\topacity: 0;\\n\\ttransition: 0.6s;\\n\\tborder-radius: 10px;\\n}\\n\\n.single-case-ac .sppb-carousel-extended-content-wrap .sppb-carousel-extended-description {\\n\\tposition: absolute;\\n\\tleft: 20px;\\n\\ttop: 20px;\\n}\\n\\n.single-case-ac .sppb-carousel-extended-item-center .sppb-carousel-extended-content-wrap {\\n\\tbottom: 30px;\\nopacity: 1;\\n}\\n\\n.single-case-ac .sppb-carousel-extended-item img {\\n\\ttransition: 0.3s;\\n}\\n\\n.single-case-ac .sppb-carousel-extended-item:hover img {\\n\\ttransform: scale(1.09);\\n}\\n\\n.single-case-ac .sppb-carousel-extended-item {\\ndisplay: block;\\n  overflow: hidden;\\n  border-radius: 10px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image_carousel_layout\":\"layout4\",\"sp_image_carousel_item\":[{\"image_carousel_img\":{\"src\":\"images\\/project\\/12.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},{\"image_carousel_img\":{\"src\":\"images\\/project\\/24.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1 copy\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},{\"image_carousel_img\":{\"src\":\"images\\/project\\/25.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1 copy\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},{\"image_carousel_img\":{\"src\":\"images\\/project\\/26.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1 copy\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},{\"image_carousel_img\":{\"src\":\"images\\/project\\/12.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1 copy\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},{\"image_carousel_img\":{\"src\":\"images\\/project\\/24.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1 copy copy\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},{\"image_carousel_img\":{\"src\":\"images\\/project\\/25.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1 copy copy\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}},{\"image_carousel_img\":{\"src\":\"images\\/project\\/26.jpg\",\"alt\":\"\",\"height\":560,\"width\":540},\"admin_label\":\"Item 1 copy copy\",\"title\":\"\",\"item_title\":\"\",\"item_subtitle\":\"\",\"item_description\":\"<span class=\\\"pre\\\">CHALLENGE<\\/span>\\n<h5 class=\\\"title\\\">Official Cleaning Service<\\/h5>\",\"image_carousel_img_link\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=1&Itemid=163\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false}}],\"carousel_overlay\":0,\"overlay_gradient\":{\"color\":\"rgba(59, 25, 208, 0.5)\",\"color2\":\"rgba(255, 79, 226, 0.5)\",\"deg\":\"125\",\"type\":\"linear\"},\"carousel_height\":500,\"carousel_item_number\":{\"xl\":3,\"md\":\"1\",\"lg\":\"1\",\"sm\":\"1\"},\"carousel_margin\":{\"xl\":\"30\",\"lg\":\"30\",\"md\":\"30\",\"sm\":\"30\",\"xs\":\"30\"},\"carousel_center_padding\":{\"xl\":\"\"},\"item_content_verti_align\":\"middle\",\"item_content_hori_align\":\"left\",\"carousel_autoplay\":1,\"carousel_interval\":4500,\"carousel_speed\":2500,\"carousel_fade\":0,\"carousel_bullet\":1,\"bullet_height\":\"6\",\"bullet_width\":\"6\",\"bullet_style\":\"active_bullet\",\"bullet_background\":\"#BBBBBB\",\"bullet_active_background\":\"var(--maincolor)\",\"carousel_arrow\":0,\"arrow_icon\":\"long_arrow\",\"arrow_style\":\"normal_arrow\",\"arrow_height\":50,\"arrow_width\":52,\"arrow_color\":\"#fff\",\"arrow_background\":\"#373bff\",\"arrow_font_size\":24,\"arrow_border_color\":\"#373bff\",\"arrow_border_radius\":\"0\",\"arrow_hover_color\":\"\",\"arrow_hover_background\":\"\",\"arrow_hover_border_color\":\"\",\"bullet_border_radius\":\"100\"}}]}],\"parent\":false},{\"id\":\"e2076395-6838-45ab-9377-2b4b5c0860b5\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"12+3+6+3\",\"columns\":[{\"id\":\"38a8a946-1c0f-4e8d-9f2b-b8ae3c30bd16\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"67fd48d0-153f-43a4-823d-07796ed859c5\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"2\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"200\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Left Images\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"50\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/testimonials\\/09.png\",\"height\":324,\"width\":264,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":0,\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"title\":\"\",\"instFormId\":\"67fd48d0-153f-43a4-823d-07796ed859c5\"}},{\"id\":\"49cba3f6-d921-418f-8696-01ef291418c3\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"80\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"200\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Right Images\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"-50\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/testimonials\\/10.png\",\"height\":318,\"width\":252,\"alt\":\"\"},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":0,\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"title\":\"\",\"instFormId\":\"49cba3f6-d921-418f-8696-01ef291418c3\"}},{\"id\":\"7958e54b-9bdd-4596-a22f-d935005916c8\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px -50px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"stok-bg\",\"global_custom_css\":\".stok-bg .sppb-addon-title {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":1,\"hidden_sm\":1,\"hidden_xs\":1,\"acl\":\"\",\"admin_label\":\"Background Moving Text\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Testimonials\",\"heading_selector\":\"div\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"100\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_addon_z_index\":\"-1\",\"instFormId\":\"9b69122e-829a-4579-b947-9a1f4e6e232e\",\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"}},\"parent\":false},{\"id\":\"d93327c6-8077-4842-9826-a559ae179ca3\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"subtitle\",\"global_custom_css\":\".subtitle span {\\n\\tpadding: 3px 7px;\\n\\tbackground: var(--maincolor);\\n\\tborder-radius: 3px;\\n\\tcolor: #fff;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Subtitle\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"<span>Client<\\/span> Feedback\",\"heading_selector\":\"p\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"15\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"27\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.04\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"var(--maincolor)\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_animation\":\"fadeInUp\"},\"parent\":false},{\"id\":\"5e888468-03cd-4a7d-92fe-b1b62e8de4d8\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"title\":\"Text Block\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 30px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":1,\"global_animationduration\":\"1000\",\"global_animationdelay\":\"200\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":0,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Section Title\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p><\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h2\",\"title\":\"Customer Feedbacks\",\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"48\",\"unit\":\"px\"},\"lg\":{\"value\":\"36\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"32\",\"unit\":\"px\"},\"xs\":{\"value\":\"24\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"62\",\"unit\":\"px\"},\"lg\":{\"value\":\"50\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"45\",\"unit\":\"px\"},\"xs\":{\"value\":\"36\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_text_color\":\"#1F1F25\",\"title_margin_top\":{\"xl\":\"-12\"},\"global_animation\":\"fadeInUp\",\"global_width\":{\"xl\":\"88\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"alignment\":{\"xl\":\"center\"}},\"parent\":false}]},{\"id\":\"c000b153-8ea8-43e7-9354-7f4196853508\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"20%\",\"lg\":\"25%\",\"md\":\"25%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[]},{\"id\":\"6905b947-51df-45ae-a947-e73671748f7e\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"60%\",\"lg\":\"50%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"1b078bc4-3067-4774-a3d9-abf22962fb01\",\"type\":\"repeatable\",\"name\":\"testimonial_carousel\",\"visibility\":true,\"title\":\"Testimonial Carousel\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><circle opacity=\\\".5\\\" cx=\\\"10.5\\\" cy=\\\"30.5\\\" r=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><circle opacity=\\\".5\\\" cx=\\\"22.5\\\" cy=\\\"30.5\\\" r=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><circle cx=\\\"16.5\\\" cy=\\\"30.5\\\" r=\\\"1.5\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M22 2H10v21h12V2zM10 0a2 2 0 00-2 2v21a2 2 0 002 2h12a2 2 0 002-2V2a2 2 0 00-2-2H10z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M6 4a1 1 0 00-1-1H1a1 1 0 000 2h3v15H1a1 1 0 100 2h4a1 1 0 001-1V4zm20 17a1 1 0 001 1h4a1 1 0 100-2h-3V5h3a1 1 0 100-2h-4a.996.996 0 00-1 1v17z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M13 7.496c0 .381.309.69.69.69h.779v.297c0 .527-.364.975-.858 1.097-.148.037-.273.157-.273.31v.848c0 .152.124.277.275.26a2.538 2.538 0 002.256-2.515V5.69a.69.69 0 00-.69-.69h-1.49a.69.69 0 00-.689.69v1.806zM16.6 7.496c0 .381.309.69.69.69h.779v.297c0 .527-.364.975-.858 1.097-.148.037-.273.157-.273.31v.848c0 .152.124.277.275.26a2.538 2.538 0 002.256-2.515V5.69a.69.69 0 00-.69-.69h-1.49a.69.69 0 00-.689.69v1.806z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M12 15a1 1 0 011-1h6a1 1 0 110 2h-6a1 1 0 01-1-1zM13 19a1 1 0 011-1h4a1 1 0 110 2h-4a1 1 0 01-1-1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"testimonial_carousel_layout\":\"testi_layout1\",\"sp_testimonial_carousel_item\":[{\"client_name\":\"Thomas Kevin\",\"client_desgination\":\"Solar manager\",\"client_message\":\"Fringilla sollicitudin luctus viverra egestas cras lacinia commodo sociosqu cubilia dictum difa tempus justo diam aliquet posuere lobortis afa placerat habitant vel auctor felis.\",\"show_rating\":1,\"client_rating\":\"5\",\"testimonial_carousel_img\":{\"src\":\"images\\/testimonials\\/08.png\",\"alt\":\"\",\"height\":60,\"width\":60},\"admin_label\":\"Item 1\",\"title\":\"\"},{\"client_name\":\"Thomas Kevin\",\"client_desgination\":\"Solar manager\",\"client_message\":\"Fringilla sollicitudin luctus viverra egestas cras lacinia commodo sociosqu cubilia dictum difa tempus justo diam aliquet posuere lobortis afa placerat habitant vel auctor felis.\",\"show_rating\":1,\"client_rating\":\"5\",\"testimonial_carousel_img\":{\"src\":\"images\\/testimonials\\/08.png\",\"alt\":\"\",\"height\":60,\"width\":60},\"admin_label\":\"Item 1 copy\",\"title\":\"\"},{\"client_name\":\"Thomas Kevin\",\"client_desgination\":\"Solar manager\",\"client_message\":\"Fringilla sollicitudin luctus viverra egestas cras lacinia commodo sociosqu cubilia dictum difa tempus justo diam aliquet posuere lobortis afa placerat habitant vel auctor felis.\",\"show_rating\":1,\"client_rating\":\"5\",\"testimonial_carousel_img\":{\"src\":\"images\\/testimonials\\/08.png\",\"alt\":\"\",\"height\":60,\"width\":60},\"admin_label\":\"Item 1 copy\",\"title\":\"\"}],\"content_alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"name_text_color\":\"var(--color-heading-1)\",\"name_margin\":{\"xl\":\"14px 0px 2px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"designation_text_color\":\"#7E7E7E\",\"message_text_color\":\"#74787C\",\"message_background\":\"#F8F8F8\",\"message_padding\":{\"xl\":\"30px 30px 30px 30px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"message_margin_bottom\":{\"xl\":40},\"avatar_layout\":\"avatar_layout3\",\"avatar_height\":{\"xl\":60},\"avatar_width\":{\"xl\":60},\"avatar_border_radius\":100,\"avatar_gap\":{\"xl\":\"0\"},\"show_quote_icon\":1,\"quote_icon_color\":\"#dbdbdb\",\"quote_icon_size\":{\"xl\":\"74\"},\"quote_icon_gap\":{\"xl\":\"0\"},\"rating_color\":\"var(--maincolor)\",\"rating_size\":{\"xl\":\"16\"},\"rating_gap\":{\"xl\":\"7\"},\"carousel_margin\":{\"xl\":15},\"carousel_autoplay\":1,\"carousel_interval\":4500,\"carousel_speed\":1500,\"carousel_bullet\":1,\"bullet_height\":\"8\",\"bullet_width\":\"8\",\"bullet_style\":\"active\",\"bullet_background\":\"#BBBBBB\",\"bullet_active_background\":\"var(--maincolor)\",\"carousel_arrow\":0,\"arrow_icon\":\"long_arrow\",\"arrow_style\":\"normal_arrow\",\"arrow_height\":50,\"arrow_width\":52,\"arrow_color\":\"#fff\",\"arrow_background\":\"#373bff\",\"arrow_font_size\":24,\"arrow_border_color\":\"#373bff\",\"arrow_border_radius\":\"0\",\"arrow_hover_color\":\"\",\"arrow_hover_background\":\"\",\"arrow_hover_border_color\":\"\",\"name_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"1.25\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"26\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"0.1\",\"unit\":\"em\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"message_typography\":{\"font\":\"\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"400\",\"size\":{\"xl\":{\"value\":\"22\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"message_margin_top\":{\"xl\":\"25\"},\"carousel_item_number\":{\"xl\":\"1\",\"lg\":\"1\",\"md\":\"1\",\"sm\":\"1\"},\"bullet_border_radius\":\"100\"}}]},{\"id\":\"a7101183-4e6d-4af5-b686-b4cfd6acd190\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"20%\",\"lg\":\"25%\",\"md\":\"25%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[]}],\"parent\":false},{\"id\":\"11dbad80-8459-4868-ae2c-f35c77fd08c2\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"120px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"3+3+3+3\",\"columns\":[{\"id\":\"508a165e-ef4e-442e-afee-c43f1f6310fb\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"50%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"67a7a2db-d46b-41b6-8ba8-2cda28d14e96\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Animated Container\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"693c4954-aa63-49e8-9af1-fc55eac5d879\",\"b17a45d2-2fda-4301-96dd-1baa823f89cd\"]},{\"id\":\"693c4954-aa63-49e8-9af1-fc55eac5d879\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"-50\",\"unit\":\"%\"},\"y\":{\"value\":\"-50\",\"unit\":\"%\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"single-counter-up-start-solari-bg-text\",\"global_custom_css\":\".single-counter-up-start-solari-bg-text .sppb-animated-number {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":1,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Bg Number\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"80\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"\",\"number_before_after_text\":\"+\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_width\":{\"xl\":\"100\"}},\"parent\":\"67a7a2db-d46b-41b6-8ba8-2cda28d14e96\"},{\"id\":\"b17a45d2-2fda-4301-96dd-1baa823f89cd\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"80\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"Team Member\",\"number_before_after_text\":\"+\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"44\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"color\":\"var(--color-heading-1)\",\"title_margin\":{\"xl\":\"-5px 0px 0px 0px\"},\"title_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"58\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":\"var(--color-heading-1)\"},\"parent\":\"67a7a2db-d46b-41b6-8ba8-2cda28d14e96\"}]},{\"id\":\"aa7cc754-8383-49e6-8e49-9eb45c5b0765\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"50%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"658c7db5-324e-4670-9cac-3f2b1f0214b6\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Animated Container\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"df9863a2-35f6-4aeb-989a-4f6b51529aed\",\"1bfde051-5b2c-4ad6-b4ff-61993d1e151e\"],\"parent\":false},{\"id\":\"df9863a2-35f6-4aeb-989a-4f6b51529aed\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"-50\",\"unit\":\"%\"},\"y\":{\"value\":\"-50\",\"unit\":\"%\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"single-counter-up-start-solari-bg-text\",\"global_custom_css\":\".single-counter-up-start-solari-bg-text .sppb-animated-number {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":1,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Bg Number\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"15\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"\",\"number_before_after_text\":\"K\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_width\":{\"xl\":\"100\"}},\"parent\":\"658c7db5-324e-4670-9cac-3f2b1f0214b6\"},{\"id\":\"1bfde051-5b2c-4ad6-b4ff-61993d1e151e\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"15\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"Work Have Done\",\"number_before_after_text\":\"K\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"44\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"color\":\"var(--color-heading-1)\",\"title_margin\":{\"xl\":\"-5px 0px 0px 0px\"},\"title_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"58\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":\"var(--color-heading-1)\"},\"parent\":\"658c7db5-324e-4670-9cac-3f2b1f0214b6\"}]},{\"id\":\"a50e29a4-0e61-4ab8-85d2-f36da2e51103\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"50%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"26e8118e-84d8-4054-97c6-924a9e02dee2\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Animated Container\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"b7a8ba87-13ea-471b-9392-17b081b8fe85\",\"ca9f0117-9ddf-4a50-987e-f498f269c0c7\"],\"parent\":false},{\"id\":\"b7a8ba87-13ea-471b-9392-17b081b8fe85\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"-50\",\"unit\":\"%\"},\"y\":{\"value\":\"-50\",\"unit\":\"%\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"single-counter-up-start-solari-bg-text\",\"global_custom_css\":\".single-counter-up-start-solari-bg-text .sppb-animated-number {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":1,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Bg Number\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"93\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"\",\"number_before_after_text\":\"K\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_width\":{\"xl\":\"100\"}},\"parent\":\"26e8118e-84d8-4054-97c6-924a9e02dee2\"},{\"id\":\"ca9f0117-9ddf-4a50-987e-f498f269c0c7\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"93\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"Happy Clients\",\"number_before_after_text\":\"K\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"44\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"color\":\"var(--color-heading-1)\",\"title_margin\":{\"xl\":\"-5px 0px 0px 0px\"},\"title_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"58\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":\"var(--color-heading-1)\"},\"parent\":\"26e8118e-84d8-4054-97c6-924a9e02dee2\"}]},{\"id\":\"31f49648-b09d-4147-94f4-02f5e73837e6\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"50%\",\"xs\":\"100%\",\"unit\":\"px\"},\"class\":\"\"},\"addons\":[{\"id\":\"b9c4c16c-82e5-4a60-a6e4-d12cc6d1b8cc\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"30px 0px 0px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Animated Container\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"caec1210-32db-4705-ba1e-f9859dcb0660\",\"2c682fc9-0b18-43fe-8ceb-841ea087bf70\"],\"parent\":false},{\"id\":\"caec1210-32db-4705-ba1e-f9859dcb0660\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"-50\",\"unit\":\"%\"},\"y\":{\"value\":\"-50\",\"unit\":\"%\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"single-counter-up-start-solari-bg-text\",\"global_custom_css\":\".single-counter-up-start-solari-bg-text .sppb-animated-number {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"absolute\",\"global_addon_position_left\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"50\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"use_global_width\":1,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"Bg Number\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"18\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"\",\"number_before_after_text\":\"K\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":false,\"weight\":\"700\",\"size\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"120\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"global_width\":{\"xl\":\"100\"}},\"parent\":\"b9c4c16c-82e5-4a60-a6e4-d12cc6d1b8cc\"},{\"id\":\"2c682fc9-0b18-43fe-8ceb-841ea087bf70\",\"type\":\"content\",\"name\":\"animated_number\",\"visibility\":true,\"title\":\"Animated Number\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M5.538 2.27h2.308v13.46H5.192V5.078l-2.538.711L2 3.52l3.538-1.25zM9.962 15.73v-1.98l4.596-4.73c1.025-1.078 1.538-1.975 1.538-2.693 0-.526-.166-.949-.5-1.27-.32-.32-.737-.48-1.25-.48-1.013 0-1.763.526-2.25 1.577l-2.23-1.308c.423-.923 1.031-1.628 1.826-2.115A4.91 4.91 0 0114.308 2c1.218 0 2.262.385 3.134 1.154.872.756 1.308 1.782 1.308 3.077 0 1.397-.737 2.833-2.212 4.308l-2.634 2.634h5.058v2.558h-9zM26.77 7.73c.91.27 1.647.744 2.21 1.424.578.667.866 1.474.866 2.423 0 1.384-.468 2.468-1.404 3.25-.923.782-2.057 1.173-3.404 1.173-1.05 0-1.993-.237-2.826-.711-.821-.488-1.417-1.2-1.789-2.135l2.27-1.308c.333 1.039 1.115 1.558 2.345 1.558.68 0 1.206-.16 1.577-.48.385-.334.577-.783.577-1.347 0-.551-.192-.994-.577-1.327-.371-.333-.897-.5-1.576-.5h-.577l-1.02-1.538 2.654-3.462h-5.27V2.27h8.462v2.192L26.77 7.73z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 24a1 1 0 01-1 1H4a1 1 0 110-2h24a1 1 0 011 1zM24 29a1 1 0 01-1 1H8a1 1 0 110-2h15a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"number\":\"18\",\"duration\":\"5000\",\"number_before_after_text_position\":\"right\",\"use_number_format\":0,\"separator_string\":\",\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"counter_title\":\"Award Winnings\",\"number_before_after_text\":\"K\",\"number_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"34\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"44\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"color\":\"var(--color-heading-1)\",\"title_margin\":{\"xl\":\"-5px 0px 0px 0px\"},\"title_typography\":{\"font\":\"Exo\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"58\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":\"var(--color-heading-1)\"},\"parent\":\"b9c4c16c-82e5-4a60-a6e4-d12cc6d1b8cc\"}]}],\"parent\":false},{\"id\":\"c3037fa8-7312-4f9a-922c-a3b147bd330b\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"120px 0px 120px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"blog\",\"class\":\"\",\"background_color\":\"#F6F6F6\"},\"layout\":\"12+6+6\",\"columns\":[{\"id\":\"53be14c4-0685-427c-b803-2dbceb7c3adf\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"100%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"7989a0ae-970f-4d96-bf6e-4ee5dc27e087\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px -50px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"stok-bg\",\"global_custom_css\":\".stok-bg .sppb-addon-title {\\n\\t-webkit-text-fill-color: transparent;\\n\\t-webkit-text-stroke-width: 1px;\\n\\t-webkit-text-stroke-color: rgba(217, 217, 217, 0.267);\\n}\",\"global_custom_position\":1,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"%\"},\"global_addon_position_top\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":1,\"hidden_sm\":1,\"hidden_xs\":1,\"acl\":\"\",\"admin_label\":\"Background Moving Text\",\"while_scroll_view\":[{\"enable_while_scroll_view\":true,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"20\",\"y\":\"0\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Our Blog\",\"heading_selector\":\"div\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"Exo\",\"uppercase\":true,\"italic\":false,\"underline\":fa